/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.util.ArrayList;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.InvalidMethodSignatureException;
import org.apache.commons.lang3.ArrayUtils;

public abstract class Utility {
    private static final ThreadLocal<Integer> CONSUMER_CHARS;
    private static final int[] CHAR_MAP;
    private static final int[] MAP_CHAR;

    public static String compactClassName(String str, boolean chopit) {
        return Utility.compactClassName(str, "java.lang.", chopit);
    }

    public static String compactClassName(String str, String prefix, boolean chopit) {
        int len = prefix.length();
        str = Utility.pathToPackage(str);
        if (chopit && str.startsWith(prefix) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static String[] methodSignatureArgumentTypes(String signature) throws ClassFormatException {
        return Utility.methodSignatureArgumentTypes(signature, true);
    }

    public static String[] methodSignatureArgumentTypes(String signature, boolean chopit) throws ClassFormatException {
        ArrayList<String> vec = new ArrayList<String>();
        try {
            int index = signature.indexOf(40) + 1;
            if (index <= 0) {
                throw new InvalidMethodSignatureException(signature);
            }
            while (signature.charAt(index) != ')') {
                vec.add(Utility.typeSignatureToString(signature.substring(index), chopit));
                index += Utility.unwrap(CONSUMER_CHARS);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new InvalidMethodSignatureException(signature, e);
        }
        return vec.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String pathToPackage(String str) {
        return str.replace('/', '.');
    }

    public static String typeSignatureToString(String signature, boolean chopit) throws ClassFormatException {
        Utility.wrap(CONSUMER_CHARS, 1);
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'T': {
                    int index = signature.indexOf(59);
                    if (index < 0) {
                        throw new ClassFormatException("Invalid type variable signature: " + signature);
                    }
                    Utility.wrap(CONSUMER_CHARS, index + 1);
                    return Utility.compactClassName(signature.substring(1, index), chopit);
                }
                case 'L': {
                    int fromIndex = signature.indexOf(60);
                    if (fromIndex < 0) {
                        fromIndex = 0;
                    } else if ((fromIndex = signature.indexOf(62, fromIndex)) < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    int index = signature.indexOf(59, fromIndex);
                    if (index < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    int bracketIndex = signature.substring(0, index).indexOf(60);
                    if (bracketIndex < 0) {
                        Utility.wrap(CONSUMER_CHARS, index + 1);
                        return Utility.compactClassName(signature.substring(1, index), chopit);
                    }
                    fromIndex = signature.indexOf(59);
                    if (fromIndex < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    if (fromIndex < bracketIndex) {
                        Utility.wrap(CONSUMER_CHARS, fromIndex + 1);
                        return Utility.compactClassName(signature.substring(1, fromIndex), chopit);
                    }
                    StringBuilder type = new StringBuilder(Utility.compactClassName(signature.substring(1, bracketIndex), chopit)).append("<");
                    int consumedChars = bracketIndex + 1;
                    if (signature.charAt(consumedChars) == '+') {
                        type.append("? extends ");
                        ++consumedChars;
                    } else if (signature.charAt(consumedChars) == '-') {
                        type.append("? super ");
                        ++consumedChars;
                    }
                    if (signature.charAt(consumedChars) == '*') {
                        type.append("?");
                        ++consumedChars;
                    } else {
                        type.append(Utility.typeSignatureToString(signature.substring(consumedChars), chopit));
                        consumedChars = Utility.unwrap(CONSUMER_CHARS) + consumedChars;
                        Utility.wrap(CONSUMER_CHARS, consumedChars);
                    }
                    while (signature.charAt(consumedChars) != '>') {
                        type.append(", ");
                        if (signature.charAt(consumedChars) == '+') {
                            type.append("? extends ");
                            ++consumedChars;
                        } else if (signature.charAt(consumedChars) == '-') {
                            type.append("? super ");
                            ++consumedChars;
                        }
                        if (signature.charAt(consumedChars) == '*') {
                            type.append("?");
                            ++consumedChars;
                            continue;
                        }
                        type.append(Utility.typeSignatureToString(signature.substring(consumedChars), chopit));
                        consumedChars = Utility.unwrap(CONSUMER_CHARS) + consumedChars;
                        Utility.wrap(CONSUMER_CHARS, consumedChars);
                    }
                    type.append(">");
                    if (signature.charAt(++consumedChars) == '.') {
                        type.append(".");
                        type.append(Utility.typeSignatureToString("L" + signature.substring(consumedChars + 1), chopit));
                        consumedChars = Utility.unwrap(CONSUMER_CHARS) + consumedChars;
                        Utility.wrap(CONSUMER_CHARS, consumedChars);
                        return type.toString();
                    }
                    if (signature.charAt(consumedChars) != ';') {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    Utility.wrap(CONSUMER_CHARS, consumedChars + 1);
                    return type.toString();
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuilder brackets = new StringBuilder();
                    int n = 0;
                    while (signature.charAt(n) == '[') {
                        brackets.append("[]");
                        ++n;
                    }
                    int consumedChars = n;
                    String type = Utility.typeSignatureToString(signature.substring(n), chopit);
                    int temp = Utility.unwrap(CONSUMER_CHARS) + consumedChars;
                    Utility.wrap(CONSUMER_CHARS, temp);
                    return type + brackets.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatException("Invalid signature: '" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid signature: " + signature, e);
        }
    }

    private static int unwrap(ThreadLocal<Integer> tl) {
        return tl.get();
    }

    private static void wrap(ThreadLocal<Integer> tl, int value) {
        tl.set(value);
    }

    static {
        int i;
        CONSUMER_CHARS = ThreadLocal.withInitial(() -> 0);
        CHAR_MAP = new int[48];
        MAP_CHAR = new int[256];
        int j = 0;
        for (i = 65; i <= 90; ++i) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
        }
        for (i = 103; i <= 122; ++i) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
        }
        Utility.CHAR_MAP[j] = 36;
        Utility.MAP_CHAR[36] = j++;
        Utility.CHAR_MAP[j] = 95;
        Utility.MAP_CHAR[95] = j;
    }
}

