/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss.repo;

import com.google.common.collect.AbstractIterator;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.Generated;
import net.md_5.ss.model.ClassInfo;
import net.md_5.ss.model.ItemInfo;
import net.md_5.ss.model.Resource;
import net.md_5.ss.repo.ClassRepo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

public class JarRepo
extends ClassRepo {
    private final JarFile jar;

    @Override
    protected ClassInfo getClass0(String internalName) throws IOException {
        JarEntry entry;
        String versionBase = "";
        if (internalName.startsWith("META-INF/versions/")) {
            String[] split = internalName.split("/", 4);
            versionBase = split[0] + "/" + split[1] + "/" + split[2] + "/";
        }
        if ((entry = this.jar.getJarEntry(internalName + ".class")) != null) {
            try (InputStream is = this.jar.getInputStream(entry);){
                ClassReader cr = new ClassReader(is);
                ClassNode node = new ClassNode();
                cr.accept(node, 0);
                ClassInfo classInfo = new ClassInfo(this, cr, node, versionBase, entry.getTime());
                return classInfo;
            }
        }
        return null;
    }

    @Override
    public Iterator<ItemInfo> iterator() {
        final Enumeration<JarEntry> entries = this.jar.entries();
        return new AbstractIterator<ItemInfo>(){

            @Override
            protected ItemInfo computeNext() {
                byte[] data;
                if (!entries.hasMoreElements()) {
                    return (ItemInfo)this.endOfData();
                }
                JarEntry entry = (JarEntry)entries.nextElement();
                String name = entry.getName();
                if (name.endsWith(".class")) {
                    String internalName = name.substring(0, name.length() - ".class".length());
                    return JarRepo.this.getClass(internalName);
                }
                try (InputStream is = JarRepo.this.jar.getInputStream(entry);){
                    data = ByteStreams.toByteArray(is);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return new Resource(entry.getName(), entry.getTime(), data);
            }
        };
    }

    @Generated
    public JarRepo(JarFile jar) {
        this.jar = jar;
    }

    @Generated
    public JarFile getJar() {
        return this.jar;
    }

    @Generated
    public String toString() {
        return "JarRepo(jar=" + this.getJar() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JarRepo)) {
            return false;
        }
        JarRepo other = (JarRepo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JarFile this$jar = this.getJar();
        JarFile other$jar = other.getJar();
        return !(this$jar == null ? other$jar != null : !this$jar.equals(other$jar));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JarRepo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JarFile $jar = this.getJar();
        result = result * 59 + ($jar == null ? 43 : $jar.hashCode());
        return result;
    }
}

