/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss.remapper;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import lombok.Generated;
import net.md_5.ss.mapping.MappingData;
import net.md_5.ss.model.ClassInfo;
import net.md_5.ss.model.FieldInfo;
import net.md_5.ss.model.MethodInfo;
import net.md_5.ss.remapper.EnhancedMethodRemapper;
import net.md_5.ss.repo.ClassRepo;
import net.md_5.ss.util.JavaTokens;
import org.objectweb.asm.commons.Remapper;

public class EnhancedRemapper
extends Remapper {
    private final ClassRepo repo;
    private final MappingData data;
    private final Collection<AutoMember> autoMember;
    private final EnhancedMethodRemapper.LVTStyle lvtStyle;

    @Override
    @Deprecated
    public final String mapRecordComponentName(String owner, String name, String desc) {
        return this.mapFieldName(owner, name, desc);
    }

    @Override
    @Deprecated
    public final String mapFieldName(String owner, String name, String desc) {
        FieldInfo declarer = this.findFieldDeclarer(owner, name, desc, false, true);
        return this.mapFieldName(owner, name, desc, declarer == null ? -1 : declarer.getAccess());
    }

    @Override
    @Deprecated
    public final String mapMethodName(String owner, String name, String desc) {
        MethodInfo declarer = this.findMethodDeclarer(owner, name, desc, false, true, true);
        return this.mapMethodName(owner, name, desc, declarer == null ? -1 : declarer.getAccess());
    }

    private FieldInfo findFieldDeclarer(String owner, String name, String desc, boolean ignoreFirst, boolean allowPrivate) {
        ClassInfo ownerInfo = this.repo.getClass(owner);
        if (ownerInfo != null) {
            FieldInfo info;
            FieldInfo fieldInfo = info = ignoreFirst ? null : ownerInfo.getField(name, desc);
            if (info == null) {
                ClassInfo parent;
                Iterator<ClassInfo> iterator = ownerInfo.getParentClasses().iterator();
                while (iterator.hasNext() && (info = this.findFieldDeclarer((parent = iterator.next()).getName(), name, desc, false, false)) == null) {
                }
            }
            if (info != null && !allowPrivate && Modifier.isPrivate(info.getAccess())) {
                return null;
            }
            return info;
        }
        return null;
    }

    private MethodInfo findMethodDeclarer(String owner, String name, String desc, boolean ignoreFirst, boolean exact, boolean allowPrivate) {
        ClassInfo ownerInfo = this.repo.getClass(owner);
        if (ownerInfo != null) {
            MethodInfo info;
            MethodInfo methodInfo = info = ignoreFirst ? null : ownerInfo.getMethod(name, desc, exact);
            if (info == null) {
                ClassInfo parent;
                Iterator<ClassInfo> iterator = ownerInfo.getParentClasses().iterator();
                while (iterator.hasNext() && (info = this.findMethodDeclarer((parent = iterator.next()).getName(), name, desc, false, exact, false)) == null) {
                }
            }
            if (info != null && !allowPrivate && Modifier.isPrivate(info.getAccess())) {
                return null;
            }
            return info;
        }
        return null;
    }

    @Override
    public String map(String typeName) {
        String mapped = this.data.getClassMap(typeName);
        if (mapped == null) {
            int lastDollar;
            String outerName = typeName;
            while ((lastDollar = outerName.lastIndexOf(36)) != -1) {
                String innerName = typeName.substring(lastDollar);
                mapped = this.data.getClassMap(outerName = outerName.substring(0, lastDollar));
                if (mapped == null) continue;
                mapped = mapped + innerName;
                break;
            }
        }
        return mapped == null ? typeName : mapped;
    }

    public String mapFieldName(String owner, String name, String desc, int access) {
        String mapped = this.mapFieldName0(owner, name, desc, access);
        if (mapped == null) {
            if (this.autoMember.contains((Object)AutoMember.TOKENS)) {
                mapped = JavaTokens.appendIfToken(name);
            }
            if (this.autoMember.contains((Object)AutoMember.LOGGER) && Modifier.isStatic(access) && Modifier.isFinal(access) && desc.equals("Lorg/apache/logging/log4j/Logger;")) {
                mapped = "LOGGER";
            }
        }
        return mapped == null ? name : mapped;
    }

    private String mapFieldName0(String owner, String name, String desc, int access) {
        FieldInfo declarer;
        String mapped = this.data.getFieldMap(owner, name);
        if (mapped == null && !Modifier.isPrivate(access) && (declarer = this.findFieldDeclarer(owner, name, desc, true, false)) != null) {
            mapped = this.mapFieldName0(declarer.getOwner().getName(), declarer.getName(), declarer.getDesc(), declarer.getAccess());
        }
        return mapped;
    }

    public String mapMethodName(String owner, String name, String desc, int access) {
        String mapped = this.mapMethodName0(owner, name, desc, access);
        if (mapped == null && this.autoMember.contains((Object)AutoMember.TOKENS)) {
            mapped = JavaTokens.appendIfToken(name);
        }
        return mapped == null ? name : mapped;
    }

    private String mapMethodName0(String owner, String name, String desc, int access) {
        MethodInfo declarer;
        String mapped = this.data.getMethodMap(owner, name, desc);
        if (mapped == null && !Modifier.isPrivate(access) && (declarer = this.findMethodDeclarer(owner, name, desc, true, false, false)) != null) {
            mapped = this.mapMethodName0(declarer.getOwner().getName(), declarer.getName(), declarer.getDesc(), declarer.getAccess());
        }
        return mapped;
    }

    @Generated
    public EnhancedRemapper(ClassRepo repo, MappingData data, Collection<AutoMember> autoMember, EnhancedMethodRemapper.LVTStyle lvtStyle) {
        this.repo = repo;
        this.data = data;
        this.autoMember = autoMember;
        this.lvtStyle = lvtStyle;
    }

    @Generated
    public ClassRepo getRepo() {
        return this.repo;
    }

    @Generated
    public MappingData getData() {
        return this.data;
    }

    @Generated
    public Collection<AutoMember> getAutoMember() {
        return this.autoMember;
    }

    @Generated
    public EnhancedMethodRemapper.LVTStyle getLvtStyle() {
        return this.lvtStyle;
    }

    @Generated
    public String toString() {
        return "EnhancedRemapper(repo=" + this.getRepo() + ", data=" + this.getData() + ", autoMember=" + this.getAutoMember() + ", lvtStyle=" + (Object)((Object)this.getLvtStyle()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnhancedRemapper)) {
            return false;
        }
        EnhancedRemapper other = (EnhancedRemapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClassRepo this$repo = this.getRepo();
        ClassRepo other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        MappingData this$data = this.getData();
        MappingData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Collection<AutoMember> this$autoMember = this.getAutoMember();
        Collection<AutoMember> other$autoMember = other.getAutoMember();
        if (this$autoMember == null ? other$autoMember != null : !((Object)this$autoMember).equals(other$autoMember)) {
            return false;
        }
        EnhancedMethodRemapper.LVTStyle this$lvtStyle = this.getLvtStyle();
        EnhancedMethodRemapper.LVTStyle other$lvtStyle = other.getLvtStyle();
        return !(this$lvtStyle == null ? other$lvtStyle != null : !((Object)((Object)this$lvtStyle)).equals((Object)other$lvtStyle));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnhancedRemapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClassRepo $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        MappingData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Collection<AutoMember> $autoMember = this.getAutoMember();
        result = result * 59 + ($autoMember == null ? 43 : ((Object)$autoMember).hashCode());
        EnhancedMethodRemapper.LVTStyle $lvtStyle = this.getLvtStyle();
        result = result * 59 + ($lvtStyle == null ? 43 : ((Object)((Object)$lvtStyle)).hashCode());
        return result;
    }

    public static enum AutoMember {
        SYNTHETIC,
        TOKENS,
        LOGGER;

    }
}

