/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.md_5.ss.model.FieldInfo;
import net.md_5.ss.model.ItemInfo;
import net.md_5.ss.model.MethodInfo;
import net.md_5.ss.remapper.ClassRemapper;
import net.md_5.ss.remapper.EnhancedRemapper;
import net.md_5.ss.repo.ClassRepo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassInfo
implements ItemInfo {
    private ClassRepo repo;
    private final ClassReader reader;
    private final ClassNode node;
    private final String versionBase;
    private final long time;
    private final Map<String, MethodInfo> methodCache = new HashMap<String, MethodInfo>();
    private final Map<String, FieldInfo> fieldCache = new HashMap<String, FieldInfo>();

    public MethodInfo getMethod(String name, String desc, boolean exact) {
        String key = name + " " + desc;
        MethodInfo info = this.methodCache.get(key);
        if (info == null) {
            Type targetType = Type.getMethodType(desc);
            for (MethodNode method : this.node.methods) {
                Type candidateType = Type.getMethodType(method.desc);
                if (!method.name.equals(name) || !(exact ? method.desc.equals(desc) : Arrays.equals(candidateType.getArgumentTypes(), targetType.getArgumentTypes()))) continue;
                info = new MethodInfo(this, name, method.desc, method.access);
                this.methodCache.put(key, info);
                break;
            }
        }
        return info;
    }

    public FieldInfo getField(String name, String desc) {
        String key = name + " " + desc;
        FieldInfo info = this.fieldCache.get(key);
        if (info == null) {
            for (FieldNode field : this.node.fields) {
                if (!field.name.equals(name) || !field.desc.equals(desc)) continue;
                info = new FieldInfo(this, name, desc, field.access);
                this.fieldCache.put(key, info);
                break;
            }
        }
        return info;
    }

    public String getName() {
        return this.node.name;
    }

    public Iterable<String> getParents() {
        return this.node.superName == null ? this.node.interfaces : Iterables.concat(this.node.interfaces, Collections.singleton(this.node.superName));
    }

    public Iterable<ClassInfo> getParentClasses() {
        return Iterables.filter(Iterables.transform(this.getParents(), new Function<String, ClassInfo>(){

            @Override
            public ClassInfo apply(String input) {
                return ClassInfo.this.repo.getClass(input);
            }
        }), new Predicate<ClassInfo>(){

            @Override
            public boolean apply(ClassInfo input) {
                return input != null;
            }
        });
    }

    public byte[] toByteArray() {
        ClassWriter cw = new ClassWriter(0);
        this.node.accept(cw);
        return cw.toByteArray();
    }

    public byte[] remap(EnhancedRemapper remapper) {
        ClassWriter cw = new ClassWriter(this.reader, 0);
        this.reader.accept(new ClassRemapper((ClassVisitor)cw, remapper), 0);
        return cw.toByteArray();
    }

    @Generated
    public ClassRepo getRepo() {
        return this.repo;
    }

    @Generated
    public ClassReader getReader() {
        return this.reader;
    }

    @Generated
    public ClassNode getNode() {
        return this.node;
    }

    @Generated
    public String getVersionBase() {
        return this.versionBase;
    }

    @Generated
    public long getTime() {
        return this.time;
    }

    @Generated
    public Map<String, MethodInfo> getMethodCache() {
        return this.methodCache;
    }

    @Generated
    public Map<String, FieldInfo> getFieldCache() {
        return this.fieldCache;
    }

    @Generated
    public void setRepo(ClassRepo repo) {
        this.repo = repo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassInfo)) {
            return false;
        }
        ClassInfo other = (ClassInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        ClassRepo this$repo = this.getRepo();
        ClassRepo other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        ClassReader this$reader = this.getReader();
        ClassReader other$reader = other.getReader();
        if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
            return false;
        }
        ClassNode this$node = this.getNode();
        ClassNode other$node = other.getNode();
        if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
            return false;
        }
        String this$versionBase = this.getVersionBase();
        String other$versionBase = other.getVersionBase();
        if (this$versionBase == null ? other$versionBase != null : !this$versionBase.equals(other$versionBase)) {
            return false;
        }
        Map<String, MethodInfo> this$methodCache = this.getMethodCache();
        Map<String, MethodInfo> other$methodCache = other.getMethodCache();
        if (this$methodCache == null ? other$methodCache != null : !((Object)this$methodCache).equals(other$methodCache)) {
            return false;
        }
        Map<String, FieldInfo> this$fieldCache = this.getFieldCache();
        Map<String, FieldInfo> other$fieldCache = other.getFieldCache();
        return !(this$fieldCache == null ? other$fieldCache != null : !((Object)this$fieldCache).equals(other$fieldCache));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        ClassRepo $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        ClassReader $reader = this.getReader();
        result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
        ClassNode $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        String $versionBase = this.getVersionBase();
        result = result * 59 + ($versionBase == null ? 43 : $versionBase.hashCode());
        Map<String, MethodInfo> $methodCache = this.getMethodCache();
        result = result * 59 + ($methodCache == null ? 43 : ((Object)$methodCache).hashCode());
        Map<String, FieldInfo> $fieldCache = this.getFieldCache();
        result = result * 59 + ($fieldCache == null ? 43 : ((Object)$fieldCache).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClassInfo(repo=" + this.getRepo() + ", reader=" + this.getReader() + ", node=" + this.getNode() + ", versionBase=" + this.getVersionBase() + ", time=" + this.getTime() + ", methodCache=" + this.getMethodCache() + ", fieldCache=" + this.getFieldCache() + ")";
    }

    @Generated
    public ClassInfo(ClassRepo repo, ClassReader reader, ClassNode node, String versionBase, long time) {
        this.repo = repo;
        this.reader = reader;
        this.node = node;
        this.versionBase = versionBase;
        this.time = time;
    }
}

