/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss.repo;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import net.md_5.ss.model.ClassInfo;
import net.md_5.ss.model.ItemInfo;
import net.md_5.ss.repo.ClassRepo;

public class AggregateRepo
extends ClassRepo {
    private final ClassRepo[] children;

    public AggregateRepo(ClassRepo ... children) {
        this.children = children;
    }

    @Override
    public ClassInfo getClass0(String internalName) {
        for (ClassRepo child : this.children) {
            ClassInfo found = child.getClass(internalName);
            if (found == null) continue;
            found.setRepo(this);
            return found;
        }
        return null;
    }

    @Override
    public Iterator<ItemInfo> iterator() {
        return Iterables.concat(this.children).iterator();
    }

    public ClassRepo[] getChildren() {
        return this.children;
    }

    public String toString() {
        return "AggregateRepo(children=" + Arrays.deepToString(this.getChildren()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateRepo)) {
            return false;
        }
        AggregateRepo other = (AggregateRepo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getChildren(), other.getChildren());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregateRepo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getChildren());
        return result;
    }
}

