/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss.remapper;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import net.md_5.ss.remapper.EnhancedRemapper;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.MethodRemapper;

public class EnhancedMethodRemapper
extends MethodRemapper {
    private static final Collection<Handle> META_FACTORIES = Arrays.asList(new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false));
    private final EnhancedRemapper remapper;
    private final int methodAccess;
    private final boolean enumConstructor;

    public EnhancedMethodRemapper(MethodVisitor methodVisitor, EnhancedRemapper remapper, int methodAccess, boolean enumConstructor) {
        super(methodVisitor, remapper);
        this.remapper = remapper;
        this.methodAccess = methodAccess;
        this.enumConstructor = enumConstructor;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        return this.enumConstructor ? null : super.visitParameterAnnotation(parameter, descriptor, visible);
    }

    @Override
    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        switch (this.remapper.getLvtStyle()) {
            case BASIC: {
                if (Modifier.isStatic(this.methodAccess)) {
                    name = "var" + index;
                    break;
                }
                name = index == 0 ? "this" : "var" + (index - 1);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot map LVT in style " + (Object)((Object)this.remapper.getLvtStyle()));
            }
        }
        super.visitLocalVariable(name, descriptor, signature, start, end, index);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        if (META_FACTORIES.contains(bootstrapMethodHandle)) {
            String owner = Type.getReturnType(descriptor).getInternalName();
            String odesc = ((Type)bootstrapMethodArguments[0]).getDescriptor();
            name = this.remapper.mapMethodName(owner, name, odesc);
        } else {
            name = this.remapper.mapInvokeDynamicMethodName(name, descriptor);
        }
        if (bootstrapMethodHandle.getOwner().equals("java/lang/runtime/ObjectMethods")) {
            Type clazz = (Type)bootstrapMethodArguments[0];
            for (int i = 2; i < bootstrapMethodArguments.length; ++i) {
                Handle h = (Handle)bootstrapMethodArguments[i];
                String newName = this.remapper.mapFieldName(clazz.getInternalName(), h.getName(), h.getDesc(), 0);
                bootstrapMethodArguments[i] = new Handle(h.getTag(), h.getOwner(), newName, h.getDesc(), h.isInterface());
            }
        }
        Object[] remappedBootstrapMethodArguments = new Object[bootstrapMethodArguments.length];
        for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
            remappedBootstrapMethodArguments[i] = this.remapper.mapValue(bootstrapMethodArguments[i]);
        }
        this.mv.visitInvokeDynamicInsn(name, this.remapper.mapMethodDesc(descriptor), (Handle)this.remapper.mapValue(bootstrapMethodHandle), remappedBootstrapMethodArguments);
    }

    public static enum LVTStyle {
        NONE,
        BASIC;

    }
}

