/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss.mapping;

import java.util.Map;
import net.md_5.ss.util.AccessTrackingMap;

public class MappingData {
    private final AccessTrackingMap<String, String> packageMaps = new AccessTrackingMap();
    private final AccessTrackingMap<String, String> classMaps = new AccessTrackingMap();
    private final AccessTrackingMap<String, String> classMapsInverse = new AccessTrackingMap();
    private final AccessTrackingMap<String, String> methodMaps = new AccessTrackingMap();
    private final AccessTrackingMap<String, String> fieldMaps = new AccessTrackingMap();

    public void addPackageMap(String from, String to) {
        this.packageMaps.put(from, to);
    }

    public String getPackageMap(String from) {
        return this.packageMaps.get(from);
    }

    public void addClassMap(String from, String to) {
        this.classMaps.put(from, to);
        this.classMapsInverse.put(to, from);
    }

    public String getClassMap(String from) {
        return this.classMaps.get(from);
    }

    public String getClassMapInverse(String to) {
        return this.classMapsInverse.get(to);
    }

    public void addMethodMap(String fromOwner, String fromName, String fromDesc, String newName) {
        this.methodMaps.put(fromOwner + ":" + fromName + " " + fromDesc, newName);
    }

    public String getMethodMap(String fromOwner, String fromName, String fromDesc) {
        return this.methodMaps.get(fromOwner + ":" + fromName + " " + fromDesc);
    }

    public void addFieldMap(String fromOwner, String fromName, String newName) {
        this.fieldMaps.put(fromOwner + ":" + fromName, newName);
    }

    public String getFieldMap(String fromOwner, String fromName) {
        return this.fieldMaps.get(fromOwner + ":" + fromName);
    }

    public String printUnused() {
        StringBuilder sb = new StringBuilder();
        for (AccessTrackingMap section : new AccessTrackingMap[]{this.packageMaps, this.classMaps, this.methodMaps, this.fieldMaps}) {
            for (Map.Entry entry : section.entrySet()) {
                if (section.isSeen(entry.getValue())) continue;
                sb.append("Unseen: ").append((String)entry.getKey()).append(" -> ").append((String)entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    public AccessTrackingMap<String, String> getPackageMaps() {
        return this.packageMaps;
    }

    public AccessTrackingMap<String, String> getClassMaps() {
        return this.classMaps;
    }

    public AccessTrackingMap<String, String> getClassMapsInverse() {
        return this.classMapsInverse;
    }

    public AccessTrackingMap<String, String> getMethodMaps() {
        return this.methodMaps;
    }

    public AccessTrackingMap<String, String> getFieldMaps() {
        return this.fieldMaps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappingData)) {
            return false;
        }
        MappingData other = (MappingData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccessTrackingMap<String, String> this$packageMaps = this.getPackageMaps();
        AccessTrackingMap<String, String> other$packageMaps = other.getPackageMaps();
        if (this$packageMaps == null ? other$packageMaps != null : !this$packageMaps.equals(other$packageMaps)) {
            return false;
        }
        AccessTrackingMap<String, String> this$classMaps = this.getClassMaps();
        AccessTrackingMap<String, String> other$classMaps = other.getClassMaps();
        if (this$classMaps == null ? other$classMaps != null : !this$classMaps.equals(other$classMaps)) {
            return false;
        }
        AccessTrackingMap<String, String> this$classMapsInverse = this.getClassMapsInverse();
        AccessTrackingMap<String, String> other$classMapsInverse = other.getClassMapsInverse();
        if (this$classMapsInverse == null ? other$classMapsInverse != null : !this$classMapsInverse.equals(other$classMapsInverse)) {
            return false;
        }
        AccessTrackingMap<String, String> this$methodMaps = this.getMethodMaps();
        AccessTrackingMap<String, String> other$methodMaps = other.getMethodMaps();
        if (this$methodMaps == null ? other$methodMaps != null : !this$methodMaps.equals(other$methodMaps)) {
            return false;
        }
        AccessTrackingMap<String, String> this$fieldMaps = this.getFieldMaps();
        AccessTrackingMap<String, String> other$fieldMaps = other.getFieldMaps();
        return !(this$fieldMaps == null ? other$fieldMaps != null : !this$fieldMaps.equals(other$fieldMaps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MappingData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccessTrackingMap<String, String> $packageMaps = this.getPackageMaps();
        result = result * 59 + ($packageMaps == null ? 43 : $packageMaps.hashCode());
        AccessTrackingMap<String, String> $classMaps = this.getClassMaps();
        result = result * 59 + ($classMaps == null ? 43 : $classMaps.hashCode());
        AccessTrackingMap<String, String> $classMapsInverse = this.getClassMapsInverse();
        result = result * 59 + ($classMapsInverse == null ? 43 : $classMapsInverse.hashCode());
        AccessTrackingMap<String, String> $methodMaps = this.getMethodMaps();
        result = result * 59 + ($methodMaps == null ? 43 : $methodMaps.hashCode());
        AccessTrackingMap<String, String> $fieldMaps = this.getFieldMaps();
        result = result * 59 + ($fieldMaps == null ? 43 : $fieldMaps.hashCode());
        return result;
    }

    public String toString() {
        return "MappingData(packageMaps=" + this.getPackageMaps() + ", classMaps=" + this.getClassMaps() + ", classMapsInverse=" + this.getClassMapsInverse() + ", methodMaps=" + this.getMethodMaps() + ", fieldMaps=" + this.getFieldMaps() + ")";
    }
}

