/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.block.spawner;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnerEntry {
    private EntitySnapshot snapshot;
    private int spawnWeight;
    private SpawnRule spawnRule;
    private Equipment equipment;

    public SpawnerEntry(@NotNull EntitySnapshot snapshot, int spawnWeight, @Nullable SpawnRule spawnRule) {
        this(snapshot, spawnWeight, spawnRule, null);
    }

    public SpawnerEntry(@NotNull EntitySnapshot snapshot, int spawnWeight, @Nullable SpawnRule spawnRule, @Nullable Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        this.snapshot = snapshot;
        this.spawnWeight = spawnWeight;
        this.spawnRule = spawnRule;
        this.equipment = equipment;
    }

    @NotNull
    public EntitySnapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(@NotNull EntitySnapshot snapshot) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        this.snapshot = snapshot;
    }

    public int getSpawnWeight() {
        return this.spawnWeight;
    }

    public void setSpawnWeight(int spawnWeight) {
        this.spawnWeight = spawnWeight;
    }

    @Nullable
    public SpawnRule getSpawnRule() {
        return this.spawnRule == null ? null : this.spawnRule.clone();
    }

    public void setSpawnRule(@Nullable SpawnRule spawnRule) {
        this.spawnRule = spawnRule;
    }

    @Nullable
    public Equipment getEquipment() {
        return this.equipment;
    }

    public void setEquipment(@Nullable Equipment equipment) {
        this.equipment = equipment;
    }

    public static class Equipment {
        private LootTable equipmentLootTable;
        private final Map<EquipmentSlot, Float> dropChances;

        public Equipment(@NotNull LootTable equipmentLootTable, @NotNull Map<EquipmentSlot, Float> dropChances) {
            this.equipmentLootTable = equipmentLootTable;
            this.dropChances = dropChances;
        }

        public void setEquipmentLootTable(@NotNull LootTable table) {
            this.equipmentLootTable = table;
        }

        @NotNull
        public LootTable getEquipmentLootTable() {
            return this.equipmentLootTable;
        }

        @NotNull
        public Map<EquipmentSlot, Float> getDropChances() {
            return this.dropChances;
        }
    }
}

