/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.registry.RegistryAware;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Art
extends OldEnum<Art>,
Keyed,
RegistryAware {
    public static final Art KEBAB = Art.getArt("kebab");
    public static final Art AZTEC = Art.getArt("aztec");
    public static final Art ALBAN = Art.getArt("alban");
    public static final Art AZTEC2 = Art.getArt("aztec2");
    public static final Art BOMB = Art.getArt("bomb");
    public static final Art PLANT = Art.getArt("plant");
    public static final Art WASTELAND = Art.getArt("wasteland");
    public static final Art POOL = Art.getArt("pool");
    public static final Art COURBET = Art.getArt("courbet");
    public static final Art SEA = Art.getArt("sea");
    public static final Art SUNSET = Art.getArt("sunset");
    public static final Art CREEBET = Art.getArt("creebet");
    public static final Art WANDERER = Art.getArt("wanderer");
    public static final Art GRAHAM = Art.getArt("graham");
    public static final Art MATCH = Art.getArt("match");
    public static final Art BUST = Art.getArt("bust");
    public static final Art STAGE = Art.getArt("stage");
    public static final Art VOID = Art.getArt("void");
    public static final Art SKULL_AND_ROSES = Art.getArt("skull_and_roses");
    public static final Art WITHER = Art.getArt("wither");
    public static final Art FIGHTERS = Art.getArt("fighters");
    public static final Art POINTER = Art.getArt("pointer");
    public static final Art PIGSCENE = Art.getArt("pigscene");
    public static final Art BURNING_SKULL = Art.getArt("burning_skull");
    public static final Art SKELETON = Art.getArt("skeleton");
    public static final Art DONKEY_KONG = Art.getArt("donkey_kong");
    public static final Art EARTH = Art.getArt("earth");
    public static final Art WIND = Art.getArt("wind");
    public static final Art WATER = Art.getArt("water");
    public static final Art FIRE = Art.getArt("fire");
    public static final Art BAROQUE = Art.getArt("baroque");
    public static final Art HUMBLE = Art.getArt("humble");
    public static final Art MEDITATIVE = Art.getArt("meditative");
    public static final Art PRAIRIE_RIDE = Art.getArt("prairie_ride");
    public static final Art UNPACKED = Art.getArt("unpacked");
    public static final Art BACKYARD = Art.getArt("backyard");
    public static final Art BOUQUET = Art.getArt("bouquet");
    public static final Art CAVEBIRD = Art.getArt("cavebird");
    public static final Art CHANGING = Art.getArt("changing");
    public static final Art COTAN = Art.getArt("cotan");
    public static final Art ENDBOSS = Art.getArt("endboss");
    public static final Art FERN = Art.getArt("fern");
    public static final Art FINDING = Art.getArt("finding");
    public static final Art LOWMIST = Art.getArt("lowmist");
    public static final Art ORB = Art.getArt("orb");
    public static final Art OWLEMONS = Art.getArt("owlemons");
    public static final Art PASSAGE = Art.getArt("passage");
    public static final Art POND = Art.getArt("pond");
    public static final Art SUNFLOWERS = Art.getArt("sunflowers");
    public static final Art TIDES = Art.getArt("tides");
    public static final Art DENNIS = Art.getArt("dennis");

    @NotNull
    private static Art getArt(@NotNull String key) {
        return Registry.ART.getOrThrow(NamespacedKey.minecraft(key));
    }

    public int getBlockWidth();

    public int getBlockHeight();

    @Override
    @Deprecated(since="1.21.4")
    @NotNull
    public NamespacedKey getKey();

    @Deprecated(since="1.6.2")
    public int getId();

    @Deprecated(since="1.6.2")
    @Nullable
    public static Art getById(int id) {
        for (Art art : Registry.ART) {
            if (id != art.getId()) continue;
            return art;
        }
        return null;
    }

    @Deprecated(since="1.21.3")
    @Nullable
    public static Art getByName(@NotNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name cannot be null");
        return Bukkit.getUnsafe().get(Registry.ART, NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
    }

    @Deprecated(since="1.21.3")
    @NotNull
    public static Art valueOf(@NotNull String name) {
        Art art = Bukkit.getUnsafe().get(Registry.ART, NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
        Preconditions.checkArgument((art != null ? 1 : 0) != 0, (String)"No art found with the name %s", (Object)name);
        return art;
    }

    @Deprecated(since="1.21.3")
    @NotNull
    public static Art[] values() {
        return Lists.newArrayList(Registry.ART).toArray(new Art[0]);
    }
}

