/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerReputationChangeEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private final UUID targetUUID;
    private final Villager.ReputationEvent reason;
    private final Villager.ReputationType reputationType;
    private final int oldValue;
    private int newValue;
    private final int maxValue;

    public VillagerReputationChangeEvent(@NotNull Villager villager, @NotNull UUID targetUUID, @NotNull Villager.ReputationEvent reason, @NotNull Villager.ReputationType reputationType, int oldValue, int newValue, int maxValue) {
        super(villager);
        this.targetUUID = targetUUID;
        this.reason = reason;
        this.reputationType = reputationType;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.maxValue = maxValue;
    }

    @NotNull
    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    @Nullable
    public Entity getTarget() {
        return Bukkit.getEntity(this.targetUUID);
    }

    @NotNull
    public Villager.ReputationEvent getReason() {
        return this.reason;
    }

    @NotNull
    public Villager.ReputationType getReputationType() {
        return this.reputationType;
    }

    public int getOldValue() {
        return this.oldValue;
    }

    public int getNewValue() {
        return this.newValue;
    }

    public void setNewValue(int newValue) {
        Preconditions.checkArgument(0 <= newValue && newValue <= this.maxValue, "new value (%s) must be between [0, %s]", newValue, this.maxValue);
        this.newValue = newValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public Villager getEntity() {
        return (Villager)super.getEntity();
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

