/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.MinecraftExperimental;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.registry.RegistryAware;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GameRule<T>
extends Keyed,
RegistryAware {
    public static final GameRule<Boolean> SHOW_ADVANCEMENT_MESSAGES = GameRule.getRule("show_advancement_messages");
    public static final GameRule<Boolean> COMMAND_BLOCK_OUTPUT = GameRule.getRule("command_block_output");
    public static final GameRule<Boolean> PLAYER_MOVEMENT_CHECK = GameRule.getRule("player_movement_check");
    public static final GameRule<Boolean> ELYTRA_MOVEMENT_CHECK = GameRule.getRule("elytra_movement_check");
    public static final GameRule<Boolean> ADVANCE_TIME = GameRule.getRule("advance_time");
    public static final GameRule<Boolean> ENTITY_DROPS = GameRule.getRule("entity_drops");
    public static final GameRule<Boolean> LIMITED_CRAFTING = GameRule.getRule("limited_crafting");
    public static final GameRule<Boolean> MOB_DROPS = GameRule.getRule("mob_drops");
    public static final GameRule<Boolean> PROJECTILES_CAN_BREAK_BLOCKS = GameRule.getRule("projectiles_can_break_blocks");
    public static final GameRule<Boolean> SPAWN_MOBS = GameRule.getRule("spawn_mobs");
    public static final GameRule<Boolean> BLOCK_DROPS = GameRule.getRule("block_drops");
    public static final GameRule<Boolean> ADVANCE_WEATHER = GameRule.getRule("advance_weather");
    public static final GameRule<Boolean> KEEP_INVENTORY = GameRule.getRule("keep_inventory");
    public static final GameRule<Boolean> LOG_ADMIN_COMMANDS = GameRule.getRule("log_admin_commands");
    public static final GameRule<Boolean> MOB_GRIEFING = GameRule.getRule("mob_griefing");
    public static final GameRule<Boolean> NATURAL_HEALTH_REGENERATION = GameRule.getRule("natural_health_regeneration");
    public static final GameRule<Boolean> REDUCED_DEBUG_INFO = GameRule.getRule("reduced_debug_info");
    public static final GameRule<Boolean> SEND_COMMAND_FEEDBACK = GameRule.getRule("send_command_feedback");
    public static final GameRule<Boolean> SHOW_DEATH_MESSAGES = GameRule.getRule("show_death_messages");
    public static final GameRule<Boolean> SPECTATORS_GENERATE_CHUNKS = GameRule.getRule("spectators_generate_chunks");
    public static final GameRule<Boolean> RAIDS = GameRule.getRule("raids");
    public static final GameRule<Boolean> SPAWN_PHANTOMS = GameRule.getRule("spawn_phantoms");
    public static final GameRule<Boolean> IMMEDIATE_RESPAWN = GameRule.getRule("immediate_respawn");
    public static final GameRule<Boolean> DROWNING_DAMAGE = GameRule.getRule("drowning_damage");
    public static final GameRule<Boolean> FALL_DAMAGE = GameRule.getRule("fall_damage");
    public static final GameRule<Boolean> FIRE_DAMAGE = GameRule.getRule("fire_damage");
    public static final GameRule<Boolean> FREEZE_DAMAGE = GameRule.getRule("freeze_damage");
    public static final GameRule<Boolean> SPAWN_PATROLS = GameRule.getRule("spawn_patrols");
    public static final GameRule<Boolean> SPAWN_WANDERING_TRADERS = GameRule.getRule("spawn_wandering_traders");
    public static final GameRule<Boolean> SPAWN_WARDENS = GameRule.getRule("spawn_wardens");
    public static final GameRule<Boolean> FORGIVE_DEAD_PLAYERS = GameRule.getRule("forgive_dead_players");
    public static final GameRule<Boolean> UNIVERSAL_ANGER = GameRule.getRule("universal_anger");
    public static final GameRule<Boolean> BLOCK_EXPLOSION_DROP_DECAY = GameRule.getRule("block_explosion_drop_decay");
    public static final GameRule<Boolean> MOB_EXPLOSION_DROP_DECAY = GameRule.getRule("mob_explosion_drop_decay");
    public static final GameRule<Boolean> TNT_EXPLOSION_DROP_DECAY = GameRule.getRule("tnt_explosion_drop_decay");
    public static final GameRule<Boolean> WATER_SOURCE_CONVERSION = GameRule.getRule("water_source_conversion");
    public static final GameRule<Boolean> LAVA_SOURCE_CONVERSION = GameRule.getRule("lava_source_conversion");
    public static final GameRule<Boolean> GLOBAL_SOUND_EVENTS = GameRule.getRule("global_sound_events");
    public static final GameRule<Boolean> SPREAD_VINES = GameRule.getRule("spread_vines");
    public static final GameRule<Boolean> ENDER_PEARLS_VANISH_ON_DEATH = GameRule.getRule("ender_pearls_vanish_on_death");
    public static final GameRule<Boolean> TNT_EXPLODES = GameRule.getRule("tnt_explodes");
    public static final GameRule<Boolean> LOCATOR_BAR = GameRule.getRule("locator_bar");
    public static final GameRule<Boolean> PVP = GameRule.getRule("pvp");
    public static final GameRule<Boolean> ALLOW_ENTERING_NETHER_USING_PORTALS = GameRule.getRule("allow_entering_nether_using_portals");
    public static final GameRule<Boolean> SPAWN_MONSTERS = GameRule.getRule("spawn_monsters");
    public static final GameRule<Boolean> COMMAND_BLOCKS_WORK = GameRule.getRule("command_blocks_work");
    public static final GameRule<Boolean> SPAWNER_BLOCKS_WORK = GameRule.getRule("spawner_blocks_work");
    public static final GameRule<Integer> RANDOM_TICK_SPEED = GameRule.getRule("random_tick_speed");
    public static final GameRule<Integer> RESPAWN_RADIUS = GameRule.getRule("respawn_radius");
    public static final GameRule<Integer> MAX_ENTITY_CRAMMING = GameRule.getRule("max_entity_cramming");
    public static final GameRule<Integer> MAX_COMMAND_SEQUENCE_LENGTH = GameRule.getRule("max_command_sequence_length");
    public static final GameRule<Integer> MAX_COMMAND_FORKS = GameRule.getRule("max_command_forks");
    public static final GameRule<Integer> MAX_BLOCK_MODIFICATIONS = GameRule.getRule("max_block_modifications");
    public static final GameRule<Integer> PLAYERS_SLEEPING_PERCENTAGE = GameRule.getRule("players_sleeping_percentage");
    public static final GameRule<Integer> MAX_SNOW_ACCUMULATION_HEIGHT = GameRule.getRule("max_snow_accumulation_height");
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRule.getRule("players_nether_portal_default_delay");
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRule.getRule("players_nether_portal_creative_delay");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.MINECART_IMPROVEMENTS)
    public static final GameRule<Integer> MAX_MINECART_SPEED = GameRule.getRule("max_minecart_speed");
    public static final GameRule<Integer> FIRE_SPREAD_RADIUS_AROUND_PLAYER = GameRule.getRule("fire_spread_radius_around_player");

    @NotNull
    private static <T> GameRule<T> getRule(@NotNull String key) {
        return Registry.GAME_RULE.getOrThrow(NamespacedKey.minecraft(key));
    }

    @Override
    @Deprecated(since="1.21.11")
    @NotNull
    public NamespacedKey getKey();

    @Deprecated(since="1.21.11")
    @NotNull
    public String getName();

    @NotNull
    public Class<T> getType();

    @Deprecated(since="1.21.11")
    @Nullable
    public static GameRule<?> getByName(@NotNull String rule) {
        Preconditions.checkNotNull(rule, "Rule cannot be null");
        return !rule.isEmpty() ? Bukkit.getUnsafe().get(Registry.GAME_RULE, NamespacedKey.fromString(rule.toLowerCase(Locale.ROOT))) : null;
    }

    @Deprecated(since="1.21.11")
    @NotNull
    public static GameRule<?>[] values() {
        return Lists.newArrayList(Registry.GAME_RULE).toArray(new GameRule[0]);
    }
}

