// Generated by delombok at Tue Dec 16 19:34:53 UTC 2025
package net.md_5.bungee.chat;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Locale;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ClickEventCustom;
import net.md_5.bungee.api.dialog.chat.ShowDialogClickEvent;

public class ClickEventSerializer {
    public static final ClickEventSerializer OLD = new ClickEventSerializer(ClickType.OLD);
    public static final ClickEventSerializer NEW = new ClickEventSerializer(ClickType.NEW);
    public static final ClickEventSerializer DIALOG = new ClickEventSerializer(ClickType.DIALOG);
    //
    private final ClickType type;


    public enum ClickType {
        OLD, NEW, DIALOG;
    }

    public ClickEvent deserialize(JsonObject clickEvent, JsonDeserializationContext context) throws JsonParseException {
        ClickEvent.Action action = ClickEvent.Action.valueOf(clickEvent.get((type == ClickType.DIALOG) ? "type" : "action").getAsString().toUpperCase(Locale.ROOT));
        switch (type) {
        case NEW: 
        case DIALOG: 
            switch (action) {
            case OPEN_URL: 
                return new ClickEvent(action, clickEvent.get("url").getAsString());
            case RUN_COMMAND: 
            case SUGGEST_COMMAND: 
                return new ClickEvent(action, clickEvent.get("command").getAsString());
            case CHANGE_PAGE: 
                int page = clickEvent.get("page").getAsInt();
                Preconditions.checkArgument(page >= 0, "Page number has to be positive");
                return new ClickEvent(action, Integer.toString(page));
            case SHOW_DIALOG: 
                return context.deserialize(clickEvent.get("dialog"), ShowDialogClickEvent.class);
            case CUSTOM: 
                return new ClickEventCustom(clickEvent.get("id").getAsString(), (clickEvent.has("payload")) ? clickEvent.get("payload").getAsString() : null);
            default: 
                return new ClickEvent(action, (clickEvent.has("value")) ? clickEvent.get("value").getAsString() : "");
            }
        case OLD: 
            return new ClickEvent(action, (clickEvent.has("value")) ? clickEvent.get("value").getAsString() : "");
        default: 
            throw new IllegalArgumentException("Unknown serializer type");
        }
    }

    public JsonElement serialize(ClickEvent src, JsonSerializationContext context) {
        JsonObject clickEvent = new JsonObject();
        String actionName = src.getAction().toString().toLowerCase(Locale.ROOT);
        clickEvent.addProperty((type == ClickType.DIALOG) ? "type" : "action", actionName.toLowerCase(Locale.ROOT));
        switch (type) {
        case NEW: 
        case DIALOG: 
            ClickEvent.Action action = ClickEvent.Action.valueOf(actionName.toUpperCase(Locale.ROOT));
            switch (action) {
            case OPEN_URL: 
                clickEvent.addProperty("url", src.getValue());
                break;
            case RUN_COMMAND: 
            case SUGGEST_COMMAND: 
                clickEvent.addProperty("command", src.getValue());
                break;
            case CHANGE_PAGE: 
                clickEvent.addProperty("page", Integer.parseInt(src.getValue()));
                break;
            case SHOW_DIALOG: 
                clickEvent.add("dialog", context.serialize(src));
                break;
            case CUSTOM: 
                ClickEventCustom custom = (ClickEventCustom) src;
                clickEvent.addProperty("id", custom.getValue());
                if (custom.getPayload() != null) {
                    clickEvent.addProperty("payload", custom.getPayload());
                }
                break;
            default: 
                clickEvent.addProperty("value", src.getValue());
                break;
            }
            break;
        case OLD: 
            clickEvent.addProperty("value", src.getValue());
            break;
        default: 
            throw new IllegalArgumentException("Unknown serializer type");
        }
        return clickEvent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClickEventSerializer(final ClickType type) {
        this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClickType getType() {
        return this.type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ClickEventSerializer)) return false;
        final ClickEventSerializer other = (ClickEventSerializer) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ClickEventSerializer;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ClickEventSerializer(type=" + this.getType() + ")";
    }
}
