/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.serializer.dialog;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.dialog.action.Action;
import net.md_5.bungee.api.dialog.action.CustomClickAction;
import net.md_5.bungee.api.dialog.action.RunCommandAction;
import net.md_5.bungee.api.dialog.action.StaticAction;
import net.md_5.bungee.chat.ClickEventSerializer;

public class DialogActionSerializer
implements JsonDeserializer<Action>,
JsonSerializer<Action> {
    private static final BiMap<String, Class<? extends Action>> DYNAMIC;

    public Action deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String type = object.get("type").getAsString();
        Class realType = (Class)DYNAMIC.get((Object)type);
        if (realType == null) {
            ClickEvent click = ClickEventSerializer.DIALOG.deserialize(json.getAsJsonObject(), context);
            return new StaticAction(click);
        }
        return (Action)context.deserialize(json, (Type)realType);
    }

    public JsonElement serialize(Action src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        if (src instanceof StaticAction) {
            return ClickEventSerializer.DIALOG.serialize(((StaticAction)src).clickEvent(), context);
        }
        Class<?> realType = src.getClass();
        String type = (String)DYNAMIC.inverse().get(realType);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object)typeOfSrc);
        JsonObject object = (JsonObject)context.serialize((Object)src, realType);
        object.addProperty("type", type);
        return object;
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)"minecraft:dynamic/custom", CustomClickAction.class);
        builder.put((Object)"minecraft:dynamic/run_command", RunCommandAction.class);
        DYNAMIC = builder.build();
    }
}

