// Generated by delombok at Tue Dec 16 19:36:13 UTC 2025
package net.md_5.bungee;

import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.ClearTitles;
import net.md_5.bungee.protocol.packet.Subtitle;
import net.md_5.bungee.protocol.packet.Title.Action;
import net.md_5.bungee.protocol.packet.TitleTimes;

public class BungeeTitle implements Title {
    private TitlePacketHolder<net.md_5.bungee.protocol.packet.Title> title;
    private TitlePacketHolder<Subtitle> subtitle;
    private TitlePacketHolder<TitleTimes> times;
    private TitlePacketHolder<ClearTitles> clear;
    private TitlePacketHolder<ClearTitles> reset;


    private static class TitlePacketHolder<T extends DefinedPacket> {
        private final net.md_5.bungee.protocol.packet.Title oldPacket;
        private final T newPacket;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TitlePacketHolder(final net.md_5.bungee.protocol.packet.Title oldPacket, final T newPacket) {
            this.oldPacket = oldPacket;
            this.newPacket = newPacket;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public net.md_5.bungee.protocol.packet.Title getOldPacket() {
            return this.oldPacket;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public T getNewPacket() {
            return this.newPacket;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof BungeeTitle.TitlePacketHolder)) return false;
            final BungeeTitle.TitlePacketHolder<?> other = (BungeeTitle.TitlePacketHolder<?>) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$oldPacket = this.getOldPacket();
            final java.lang.Object other$oldPacket = other.getOldPacket();
            if (this$oldPacket == null ? other$oldPacket != null : !this$oldPacket.equals(other$oldPacket)) return false;
            final java.lang.Object this$newPacket = this.getNewPacket();
            final java.lang.Object other$newPacket = other.getNewPacket();
            if (this$newPacket == null ? other$newPacket != null : !this$newPacket.equals(other$newPacket)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof BungeeTitle.TitlePacketHolder;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $oldPacket = this.getOldPacket();
            result = result * PRIME + ($oldPacket == null ? 43 : $oldPacket.hashCode());
            final java.lang.Object $newPacket = this.getNewPacket();
            result = result * PRIME + ($newPacket == null ? 43 : $newPacket.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "BungeeTitle.TitlePacketHolder(oldPacket=" + this.getOldPacket() + ", newPacket=" + this.getNewPacket() + ")";
        }
    }

    private static TitlePacketHolder<TitleTimes> createAnimationPacket() {
        TitlePacketHolder<TitleTimes> title = new TitlePacketHolder<>(new net.md_5.bungee.protocol.packet.Title(Action.TIMES), new TitleTimes());
        title.oldPacket.setFadeIn(20);
        title.oldPacket.setStay(60);
        title.oldPacket.setFadeOut(20);
        title.newPacket.setFadeIn(20);
        title.newPacket.setStay(60);
        title.newPacket.setFadeOut(20);
        return title;
    }

    @Override
    public Title title(BaseComponent text) {
        if (title == null) {
            net.md_5.bungee.protocol.packet.Title packet = new net.md_5.bungee.protocol.packet.Title(Action.TITLE);
            title = new TitlePacketHolder<>(packet, packet);
        }
        title.oldPacket.setText(text); // = newPacket
        return this;
    }

    @Override
    public Title title(BaseComponent... text) {
        return title(TextComponent.fromArray(text));
    }

    @Override
    public Title subTitle(BaseComponent text) {
        if (subtitle == null) {
            subtitle = new TitlePacketHolder<>(new net.md_5.bungee.protocol.packet.Title(Action.SUBTITLE), new Subtitle());
        }
        subtitle.oldPacket.setText(text);
        subtitle.newPacket.setText(text);
        return this;
    }

    @Override
    public Title subTitle(BaseComponent... text) {
        return subTitle(TextComponent.fromArray(text));
    }

    @Override
    public Title fadeIn(int ticks) {
        if (times == null) {
            times = createAnimationPacket();
        }
        times.oldPacket.setFadeIn(ticks);
        times.newPacket.setFadeIn(ticks);
        return this;
    }

    @Override
    public Title stay(int ticks) {
        if (times == null) {
            times = createAnimationPacket();
        }
        times.oldPacket.setStay(ticks);
        times.newPacket.setStay(ticks);
        return this;
    }

    @Override
    public Title fadeOut(int ticks) {
        if (times == null) {
            times = createAnimationPacket();
        }
        times.oldPacket.setFadeOut(ticks);
        times.newPacket.setFadeOut(ticks);
        return this;
    }

    @Override
    public Title clear() {
        if (clear == null) {
            clear = new TitlePacketHolder<>(new net.md_5.bungee.protocol.packet.Title(Action.CLEAR), new ClearTitles());
        }
        title = null; // No need to send title if we clear it after that again
        return this;
    }

    @Override
    public Title reset() {
        if (reset == null) {
            reset = new TitlePacketHolder<>(new net.md_5.bungee.protocol.packet.Title(Action.RESET), new ClearTitles(true));
        }
        // No need to send these packets if we reset them later
        title = null;
        subtitle = null;
        times = null;
        return this;
    }

    private static void sendPacket(ProxiedPlayer player, TitlePacketHolder packet) {
        if (packet != null) {
            if (player.getPendingConnection().getVersion() >= ProtocolConstants.MINECRAFT_1_17) {
                player.unsafe().sendPacketQueued(packet.newPacket);
            } else {
                player.unsafe().sendPacket(packet.oldPacket);
            }
        }
    }

    @Override
    public Title send(ProxiedPlayer player) {
        sendPacket(player, clear);
        sendPacket(player, reset);
        sendPacket(player, times);
        sendPacket(player, subtitle);
        sendPacket(player, title);
        return this;
    }
}
