// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class TabCompleteResponse extends DefinedPacket {
    private int transactionId;
    private Suggestions suggestions;
    //
    private List<String> commands;

    public TabCompleteResponse(int transactionId, Suggestions suggestions) {
        this.transactionId = transactionId;
        this.suggestions = suggestions;
    }

    public TabCompleteResponse(List<String> commands) {
        this.commands = commands;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) {
            transactionId = readVarInt(buf);
            int start = readVarInt(buf);
            int length = readVarInt(buf);
            StringRange range = StringRange.between(start, start + length);
            int cnt = readVarInt(buf);
            List<Suggestion> matches = new LinkedList<>();
            for (int i = 0; i < cnt; i++) {
                String match = readString(buf);
                BaseComponent tooltip = buf.readBoolean() ? readBaseComponent(buf, protocolVersion) : null;
                matches.add(new Suggestion(range, match, (tooltip != null) ? new ComponentMessage(tooltip) : null));
            }
            suggestions = new Suggestions(range, matches);
        } else {
            commands = readStringArray(buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) {
            writeVarInt(transactionId, buf);
            writeVarInt(suggestions.getRange().getStart(), buf);
            writeVarInt(suggestions.getRange().getLength(), buf);
            writeVarInt(suggestions.getList().size(), buf);
            for (Suggestion suggestion : suggestions.getList()) {
                writeString(suggestion.getText(), buf);
                buf.writeBoolean(suggestion.getTooltip() != null);
                if (suggestion.getTooltip() != null) {
                    writeBaseComponent(((ComponentMessage) suggestion.getTooltip()).getComponent(), buf, protocolVersion);
                }
            }
        } else {
            writeStringArray(commands, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }


    private static class ComponentMessage implements Message {
        private final BaseComponent component;

        @Override
        public String getString() {
            return component.toPlainText();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ComponentMessage(final BaseComponent component) {
            this.component = component;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public BaseComponent getComponent() {
            return this.component;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof TabCompleteResponse.ComponentMessage)) return false;
            final TabCompleteResponse.ComponentMessage other = (TabCompleteResponse.ComponentMessage) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$component = this.getComponent();
            final java.lang.Object other$component = other.getComponent();
            if (this$component == null ? other$component != null : !this$component.equals(other$component)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof TabCompleteResponse.ComponentMessage;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $component = this.getComponent();
            result = result * PRIME + ($component == null ? 43 : $component.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TabCompleteResponse.ComponentMessage(component=" + this.getComponent() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getTransactionId() {
        return this.transactionId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Suggestions getSuggestions() {
        return this.suggestions;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTransactionId(final int transactionId) {
        this.transactionId = transactionId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSuggestions(final Suggestions suggestions) {
        this.suggestions = suggestions;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCommands(final List<String> commands) {
        this.commands = commands;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TabCompleteResponse(transactionId=" + this.getTransactionId() + ", suggestions=" + this.getSuggestions() + ", commands=" + this.getCommands() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TabCompleteResponse() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TabCompleteResponse)) return false;
        final TabCompleteResponse other = (TabCompleteResponse) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getTransactionId() != other.getTransactionId()) return false;
        final java.lang.Object this$suggestions = this.getSuggestions();
        final java.lang.Object other$suggestions = other.getSuggestions();
        if (this$suggestions == null ? other$suggestions != null : !this$suggestions.equals(other$suggestions)) return false;
        final java.lang.Object this$commands = this.getCommands();
        final java.lang.Object other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !this$commands.equals(other$commands)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TabCompleteResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getTransactionId();
        final java.lang.Object $suggestions = this.getSuggestions();
        result = result * PRIME + ($suggestions == null ? 43 : $suggestions.hashCode());
        final java.lang.Object $commands = this.getCommands();
        result = result * PRIME + ($commands == null ? 43 : $commands.hashCode());
        return result;
    }
}
