// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.Location;

public class Login extends DefinedPacket {
    private int entityId;
    private boolean hardcore;
    private short gameMode;
    private short previousGameMode;
    private Set<String> worldNames;
    private Tag dimensions;
    private Object dimension;
    private String worldName;
    private long seed;
    private short difficulty;
    private int maxPlayers;
    private String levelType;
    private int viewDistance;
    private int simulationDistance;
    private boolean reducedDebugInfo;
    private boolean normalRespawn;
    private boolean limitedCrafting;
    private boolean debug;
    private boolean flat;
    private Location deathLocation;
    private int portalCooldown;
    private int seaLevel;
    private boolean secureProfile;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        entityId = buf.readInt();
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16_2) {
            hardcore = buf.readBoolean();
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
            gameMode = buf.readUnsignedByte();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                previousGameMode = buf.readUnsignedByte();
            }
            worldNames = new HashSet<>();
            int worldCount = readVarInt(buf);
            for (int i = 0; i < worldCount; i++) {
                worldNames.add(readString(buf));
            }
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                dimensions = readTag(buf, protocolVersion);
            }
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16_2 && protocolVersion < ProtocolConstants.MINECRAFT_1_19) {
                dimension = readTag(buf, protocolVersion);
            } else if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                dimension = readString(buf);
            }
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                worldName = readString(buf);
            }
        } else if (protocolVersion > ProtocolConstants.MINECRAFT_1_9) {
            dimension = buf.readInt();
        } else {
            dimension = (int) buf.readByte();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_15 && protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
            seed = buf.readLong();
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_14) {
            difficulty = buf.readUnsignedByte();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16_2) {
            maxPlayers = readVarInt(buf);
        } else {
            maxPlayers = buf.readUnsignedByte();
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_16) {
            levelType = readString(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_14) {
            viewDistance = readVarInt(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_18) {
            simulationDistance = readVarInt(buf);
        }
        if (protocolVersion >= 29) {
            reducedDebugInfo = buf.readBoolean();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_15) {
            normalRespawn = buf.readBoolean();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_2) {
            limitedCrafting = buf.readBoolean();
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5) {
                dimension = readVarInt(buf);
            } else {
                dimension = readString(buf);
            }
            worldName = readString(buf);
            seed = buf.readLong();
            gameMode = buf.readUnsignedByte();
            previousGameMode = buf.readByte();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            debug = buf.readBoolean();
            flat = buf.readBoolean();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19) {
            if (buf.readBoolean()) {
                deathLocation = new Location(readString(buf), buf.readLong());
            }
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20) {
            portalCooldown = readVarInt(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_2) {
            seaLevel = readVarInt(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5) {
            secureProfile = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        buf.writeInt(entityId);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16_2) {
            buf.writeBoolean(hardcore);
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
            buf.writeByte(gameMode);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                buf.writeByte(previousGameMode);
            }
            writeVarInt(worldNames.size(), buf);
            for (String world : worldNames) {
                writeString(world, buf);
            }
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                writeTag(dimensions, buf, protocolVersion);
            }
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16_2 && protocolVersion < ProtocolConstants.MINECRAFT_1_19) {
                writeTag((Tag) dimension, buf, protocolVersion);
            } else if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                writeString((String) dimension, buf);
            }
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                writeString(worldName, buf);
            }
        } else if (protocolVersion > ProtocolConstants.MINECRAFT_1_9) {
            buf.writeInt((Integer) dimension);
        } else {
            buf.writeByte((Integer) dimension);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_15) {
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                buf.writeLong(seed);
            }
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_14) {
            buf.writeByte(difficulty);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16_2) {
            writeVarInt(maxPlayers, buf);
        } else {
            buf.writeByte(maxPlayers);
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_16) {
            writeString(levelType, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_14) {
            writeVarInt(viewDistance, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_18) {
            writeVarInt(simulationDistance, buf);
        }
        if (protocolVersion >= 29) {
            buf.writeBoolean(reducedDebugInfo);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_15) {
            buf.writeBoolean(normalRespawn);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_2) {
            buf.writeBoolean(limitedCrafting);
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5) {
                writeVarInt((Integer) dimension, buf);
            } else {
                writeString((String) dimension, buf);
            }
            writeString(worldName, buf);
            buf.writeLong(seed);
            buf.writeByte(gameMode);
            buf.writeByte(previousGameMode);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            buf.writeBoolean(debug);
            buf.writeBoolean(flat);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19) {
            if (deathLocation != null) {
                buf.writeBoolean(true);
                writeString(deathLocation.getDimension(), buf);
                buf.writeLong(deathLocation.getPos());
            } else {
                buf.writeBoolean(false);
            }
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20) {
            writeVarInt(portalCooldown, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_2) {
            writeVarInt(seaLevel, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5) {
            buf.writeBoolean(secureProfile);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getEntityId() {
        return this.entityId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isHardcore() {
        return this.hardcore;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public short getGameMode() {
        return this.gameMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public short getPreviousGameMode() {
        return this.previousGameMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getWorldNames() {
        return this.worldNames;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Tag getDimensions() {
        return this.dimensions;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getDimension() {
        return this.dimension;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorldName() {
        return this.worldName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long getSeed() {
        return this.seed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public short getDifficulty() {
        return this.difficulty;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLevelType() {
        return this.levelType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getViewDistance() {
        return this.viewDistance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isNormalRespawn() {
        return this.normalRespawn;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isLimitedCrafting() {
        return this.limitedCrafting;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isDebug() {
        return this.debug;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isFlat() {
        return this.flat;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Location getDeathLocation() {
        return this.deathLocation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getSeaLevel() {
        return this.seaLevel;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isSecureProfile() {
        return this.secureProfile;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEntityId(final int entityId) {
        this.entityId = entityId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHardcore(final boolean hardcore) {
        this.hardcore = hardcore;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGameMode(final short gameMode) {
        this.gameMode = gameMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPreviousGameMode(final short previousGameMode) {
        this.previousGameMode = previousGameMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWorldNames(final Set<String> worldNames) {
        this.worldNames = worldNames;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDimensions(final Tag dimensions) {
        this.dimensions = dimensions;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDimension(final Object dimension) {
        this.dimension = dimension;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWorldName(final String worldName) {
        this.worldName = worldName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSeed(final long seed) {
        this.seed = seed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDifficulty(final short difficulty) {
        this.difficulty = difficulty;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMaxPlayers(final int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLevelType(final String levelType) {
        this.levelType = levelType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setViewDistance(final int viewDistance) {
        this.viewDistance = viewDistance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSimulationDistance(final int simulationDistance) {
        this.simulationDistance = simulationDistance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReducedDebugInfo(final boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNormalRespawn(final boolean normalRespawn) {
        this.normalRespawn = normalRespawn;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLimitedCrafting(final boolean limitedCrafting) {
        this.limitedCrafting = limitedCrafting;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDebug(final boolean debug) {
        this.debug = debug;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFlat(final boolean flat) {
        this.flat = flat;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDeathLocation(final Location deathLocation) {
        this.deathLocation = deathLocation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPortalCooldown(final int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSeaLevel(final int seaLevel) {
        this.seaLevel = seaLevel;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSecureProfile(final boolean secureProfile) {
        this.secureProfile = secureProfile;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Login(entityId=" + this.getEntityId() + ", hardcore=" + this.isHardcore() + ", gameMode=" + this.getGameMode() + ", previousGameMode=" + this.getPreviousGameMode() + ", worldNames=" + this.getWorldNames() + ", dimensions=" + this.getDimensions() + ", dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", seed=" + this.getSeed() + ", difficulty=" + this.getDifficulty() + ", maxPlayers=" + this.getMaxPlayers() + ", levelType=" + this.getLevelType() + ", viewDistance=" + this.getViewDistance() + ", simulationDistance=" + this.getSimulationDistance() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ", normalRespawn=" + this.isNormalRespawn() + ", limitedCrafting=" + this.isLimitedCrafting() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", deathLocation=" + this.getDeathLocation() + ", portalCooldown=" + this.getPortalCooldown() + ", seaLevel=" + this.getSeaLevel() + ", secureProfile=" + this.isSecureProfile() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Login() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Login(final int entityId, final boolean hardcore, final short gameMode, final short previousGameMode, final Set<String> worldNames, final Tag dimensions, final Object dimension, final String worldName, final long seed, final short difficulty, final int maxPlayers, final String levelType, final int viewDistance, final int simulationDistance, final boolean reducedDebugInfo, final boolean normalRespawn, final boolean limitedCrafting, final boolean debug, final boolean flat, final Location deathLocation, final int portalCooldown, final int seaLevel, final boolean secureProfile) {
        this.entityId = entityId;
        this.hardcore = hardcore;
        this.gameMode = gameMode;
        this.previousGameMode = previousGameMode;
        this.worldNames = worldNames;
        this.dimensions = dimensions;
        this.dimension = dimension;
        this.worldName = worldName;
        this.seed = seed;
        this.difficulty = difficulty;
        this.maxPlayers = maxPlayers;
        this.levelType = levelType;
        this.viewDistance = viewDistance;
        this.simulationDistance = simulationDistance;
        this.reducedDebugInfo = reducedDebugInfo;
        this.normalRespawn = normalRespawn;
        this.limitedCrafting = limitedCrafting;
        this.debug = debug;
        this.flat = flat;
        this.deathLocation = deathLocation;
        this.portalCooldown = portalCooldown;
        this.seaLevel = seaLevel;
        this.secureProfile = secureProfile;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Login)) return false;
        final Login other = (Login) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getEntityId() != other.getEntityId()) return false;
        if (this.isHardcore() != other.isHardcore()) return false;
        if (this.getGameMode() != other.getGameMode()) return false;
        if (this.getPreviousGameMode() != other.getPreviousGameMode()) return false;
        if (this.getSeed() != other.getSeed()) return false;
        if (this.getDifficulty() != other.getDifficulty()) return false;
        if (this.getMaxPlayers() != other.getMaxPlayers()) return false;
        if (this.getViewDistance() != other.getViewDistance()) return false;
        if (this.getSimulationDistance() != other.getSimulationDistance()) return false;
        if (this.isReducedDebugInfo() != other.isReducedDebugInfo()) return false;
        if (this.isNormalRespawn() != other.isNormalRespawn()) return false;
        if (this.isLimitedCrafting() != other.isLimitedCrafting()) return false;
        if (this.isDebug() != other.isDebug()) return false;
        if (this.isFlat() != other.isFlat()) return false;
        if (this.getPortalCooldown() != other.getPortalCooldown()) return false;
        if (this.getSeaLevel() != other.getSeaLevel()) return false;
        if (this.isSecureProfile() != other.isSecureProfile()) return false;
        final java.lang.Object this$worldNames = this.getWorldNames();
        final java.lang.Object other$worldNames = other.getWorldNames();
        if (this$worldNames == null ? other$worldNames != null : !this$worldNames.equals(other$worldNames)) return false;
        final java.lang.Object this$dimensions = this.getDimensions();
        final java.lang.Object other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !this$dimensions.equals(other$dimensions)) return false;
        final java.lang.Object this$dimension = this.getDimension();
        final java.lang.Object other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) return false;
        final java.lang.Object this$worldName = this.getWorldName();
        final java.lang.Object other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) return false;
        final java.lang.Object this$levelType = this.getLevelType();
        final java.lang.Object other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) return false;
        final java.lang.Object this$deathLocation = this.getDeathLocation();
        final java.lang.Object other$deathLocation = other.getDeathLocation();
        if (this$deathLocation == null ? other$deathLocation != null : !this$deathLocation.equals(other$deathLocation)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Login;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getEntityId();
        result = result * PRIME + (this.isHardcore() ? 79 : 97);
        result = result * PRIME + this.getGameMode();
        result = result * PRIME + this.getPreviousGameMode();
        final long $seed = this.getSeed();
        result = result * PRIME + (int) ($seed >>> 32 ^ $seed);
        result = result * PRIME + this.getDifficulty();
        result = result * PRIME + this.getMaxPlayers();
        result = result * PRIME + this.getViewDistance();
        result = result * PRIME + this.getSimulationDistance();
        result = result * PRIME + (this.isReducedDebugInfo() ? 79 : 97);
        result = result * PRIME + (this.isNormalRespawn() ? 79 : 97);
        result = result * PRIME + (this.isLimitedCrafting() ? 79 : 97);
        result = result * PRIME + (this.isDebug() ? 79 : 97);
        result = result * PRIME + (this.isFlat() ? 79 : 97);
        result = result * PRIME + this.getPortalCooldown();
        result = result * PRIME + this.getSeaLevel();
        result = result * PRIME + (this.isSecureProfile() ? 79 : 97);
        final java.lang.Object $worldNames = this.getWorldNames();
        result = result * PRIME + ($worldNames == null ? 43 : $worldNames.hashCode());
        final java.lang.Object $dimensions = this.getDimensions();
        result = result * PRIME + ($dimensions == null ? 43 : $dimensions.hashCode());
        final java.lang.Object $dimension = this.getDimension();
        result = result * PRIME + ($dimension == null ? 43 : $dimension.hashCode());
        final java.lang.Object $worldName = this.getWorldName();
        result = result * PRIME + ($worldName == null ? 43 : $worldName.hashCode());
        final java.lang.Object $levelType = this.getLevelType();
        result = result * PRIME + ($levelType == null ? 43 : $levelType.hashCode());
        final java.lang.Object $deathLocation = this.getDeathLocation();
        result = result * PRIME + ($deathLocation == null ? 43 : $deathLocation.hashCode());
        return result;
    }
}
