// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class TabCompleteRequest extends DefinedPacket {
    private int transactionId;
    private String cursor;
    private boolean assumeCommand;
    private boolean hasPositon;
    private long position;

    public TabCompleteRequest(int transactionId, String cursor) {
        this.transactionId = transactionId;
        this.cursor = cursor;
    }

    public TabCompleteRequest(String cursor, boolean assumeCommand, boolean hasPosition, long position) {
        this.cursor = cursor;
        this.assumeCommand = assumeCommand;
        this.hasPositon = hasPosition;
        this.position = position;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) {
            transactionId = readVarInt(buf);
        }
        cursor = readString(buf, (protocolVersion > ProtocolConstants.MINECRAFT_1_13 ? 32500 : (protocolVersion == ProtocolConstants.MINECRAFT_1_13 ? 256 : 32767)));
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_13) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_9) {
                assumeCommand = buf.readBoolean();
            }
            if (hasPositon = buf.readBoolean()) {
                position = buf.readLong();
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) {
            writeVarInt(transactionId, buf);
        }
        writeString(cursor, buf);
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_13) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_9) {
                buf.writeBoolean(assumeCommand);
            }
            buf.writeBoolean(hasPositon);
            if (hasPositon) {
                buf.writeLong(position);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getTransactionId() {
        return this.transactionId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCursor() {
        return this.cursor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isAssumeCommand() {
        return this.assumeCommand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isHasPositon() {
        return this.hasPositon;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long getPosition() {
        return this.position;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTransactionId(final int transactionId) {
        this.transactionId = transactionId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCursor(final String cursor) {
        this.cursor = cursor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAssumeCommand(final boolean assumeCommand) {
        this.assumeCommand = assumeCommand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHasPositon(final boolean hasPositon) {
        this.hasPositon = hasPositon;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPosition(final long position) {
        this.position = position;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TabCompleteRequest(transactionId=" + this.getTransactionId() + ", cursor=" + this.getCursor() + ", assumeCommand=" + this.isAssumeCommand() + ", hasPositon=" + this.isHasPositon() + ", position=" + this.getPosition() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TabCompleteRequest() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TabCompleteRequest)) return false;
        final TabCompleteRequest other = (TabCompleteRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getTransactionId() != other.getTransactionId()) return false;
        if (this.isAssumeCommand() != other.isAssumeCommand()) return false;
        if (this.isHasPositon() != other.isHasPositon()) return false;
        if (this.getPosition() != other.getPosition()) return false;
        final java.lang.Object this$cursor = this.getCursor();
        final java.lang.Object other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TabCompleteRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getTransactionId();
        result = result * PRIME + (this.isAssumeCommand() ? 79 : 97);
        result = result * PRIME + (this.isHasPositon() ? 79 : 97);
        final long $position = this.getPosition();
        result = result * PRIME + (int) ($position >>> 32 ^ $position);
        final java.lang.Object $cursor = this.getCursor();
        result = result * PRIME + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }
}
