// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.Location;

public class Respawn extends DefinedPacket {
    private Object dimension;
    private String worldName;
    private long seed;
    private short difficulty;
    private short gameMode;
    private short previousGameMode;
    private String levelType;
    private boolean debug;
    private boolean flat;
    private byte copyMeta;
    private Location deathLocation;
    private int portalCooldown;
    private int seaLevel;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5) {
                dimension = readVarInt(buf);
            } else if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16_2 && protocolVersion < ProtocolConstants.MINECRAFT_1_19) {
                dimension = readTag(buf, protocolVersion);
            } else {
                dimension = readString(buf);
            }
            worldName = readString(buf);
        } else {
            dimension = buf.readInt();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_15) {
            seed = buf.readLong();
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_14) {
            difficulty = buf.readUnsignedByte();
        }
        gameMode = buf.readUnsignedByte();
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            previousGameMode = buf.readUnsignedByte();
            debug = buf.readBoolean();
            flat = buf.readBoolean();
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                copyMeta = buf.readByte();
            }
        } else {
            levelType = readString(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19) {
            if (buf.readBoolean()) {
                deathLocation = new Location(readString(buf), buf.readLong());
            }
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20) {
            portalCooldown = readVarInt(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_2) {
            seaLevel = readVarInt(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_2) {
            copyMeta = buf.readByte();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5) {
                writeVarInt((Integer) dimension, buf);
            } else if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16_2 && protocolVersion < ProtocolConstants.MINECRAFT_1_19) {
                writeTag((Tag) dimension, buf, protocolVersion);
            } else {
                writeString((String) dimension, buf);
            }
            writeString(worldName, buf);
        } else {
            buf.writeInt(((Integer) dimension));
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_15) {
            buf.writeLong(seed);
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_14) {
            buf.writeByte(difficulty);
        }
        buf.writeByte(gameMode);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            buf.writeByte(previousGameMode);
            buf.writeBoolean(debug);
            buf.writeBoolean(flat);
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_2) {
                buf.writeByte(copyMeta);
            }
        } else {
            writeString(levelType, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19) {
            if (deathLocation != null) {
                buf.writeBoolean(true);
                writeString(deathLocation.getDimension(), buf);
                buf.writeLong(deathLocation.getPos());
            } else {
                buf.writeBoolean(false);
            }
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20) {
            writeVarInt(portalCooldown, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_2) {
            writeVarInt(seaLevel, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_2) {
            buf.writeByte(copyMeta);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getDimension() {
        return this.dimension;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorldName() {
        return this.worldName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long getSeed() {
        return this.seed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public short getDifficulty() {
        return this.difficulty;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public short getGameMode() {
        return this.gameMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public short getPreviousGameMode() {
        return this.previousGameMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLevelType() {
        return this.levelType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isDebug() {
        return this.debug;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isFlat() {
        return this.flat;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getCopyMeta() {
        return this.copyMeta;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Location getDeathLocation() {
        return this.deathLocation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getSeaLevel() {
        return this.seaLevel;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDimension(final Object dimension) {
        this.dimension = dimension;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWorldName(final String worldName) {
        this.worldName = worldName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSeed(final long seed) {
        this.seed = seed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDifficulty(final short difficulty) {
        this.difficulty = difficulty;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGameMode(final short gameMode) {
        this.gameMode = gameMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPreviousGameMode(final short previousGameMode) {
        this.previousGameMode = previousGameMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLevelType(final String levelType) {
        this.levelType = levelType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDebug(final boolean debug) {
        this.debug = debug;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFlat(final boolean flat) {
        this.flat = flat;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCopyMeta(final byte copyMeta) {
        this.copyMeta = copyMeta;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDeathLocation(final Location deathLocation) {
        this.deathLocation = deathLocation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPortalCooldown(final int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSeaLevel(final int seaLevel) {
        this.seaLevel = seaLevel;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Respawn(dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", seed=" + this.getSeed() + ", difficulty=" + this.getDifficulty() + ", gameMode=" + this.getGameMode() + ", previousGameMode=" + this.getPreviousGameMode() + ", levelType=" + this.getLevelType() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", copyMeta=" + this.getCopyMeta() + ", deathLocation=" + this.getDeathLocation() + ", portalCooldown=" + this.getPortalCooldown() + ", seaLevel=" + this.getSeaLevel() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Respawn() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Respawn(final Object dimension, final String worldName, final long seed, final short difficulty, final short gameMode, final short previousGameMode, final String levelType, final boolean debug, final boolean flat, final byte copyMeta, final Location deathLocation, final int portalCooldown, final int seaLevel) {
        this.dimension = dimension;
        this.worldName = worldName;
        this.seed = seed;
        this.difficulty = difficulty;
        this.gameMode = gameMode;
        this.previousGameMode = previousGameMode;
        this.levelType = levelType;
        this.debug = debug;
        this.flat = flat;
        this.copyMeta = copyMeta;
        this.deathLocation = deathLocation;
        this.portalCooldown = portalCooldown;
        this.seaLevel = seaLevel;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Respawn)) return false;
        final Respawn other = (Respawn) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getSeed() != other.getSeed()) return false;
        if (this.getDifficulty() != other.getDifficulty()) return false;
        if (this.getGameMode() != other.getGameMode()) return false;
        if (this.getPreviousGameMode() != other.getPreviousGameMode()) return false;
        if (this.isDebug() != other.isDebug()) return false;
        if (this.isFlat() != other.isFlat()) return false;
        if (this.getCopyMeta() != other.getCopyMeta()) return false;
        if (this.getPortalCooldown() != other.getPortalCooldown()) return false;
        if (this.getSeaLevel() != other.getSeaLevel()) return false;
        final java.lang.Object this$dimension = this.getDimension();
        final java.lang.Object other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) return false;
        final java.lang.Object this$worldName = this.getWorldName();
        final java.lang.Object other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) return false;
        final java.lang.Object this$levelType = this.getLevelType();
        final java.lang.Object other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) return false;
        final java.lang.Object this$deathLocation = this.getDeathLocation();
        final java.lang.Object other$deathLocation = other.getDeathLocation();
        if (this$deathLocation == null ? other$deathLocation != null : !this$deathLocation.equals(other$deathLocation)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Respawn;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final long $seed = this.getSeed();
        result = result * PRIME + (int) ($seed >>> 32 ^ $seed);
        result = result * PRIME + this.getDifficulty();
        result = result * PRIME + this.getGameMode();
        result = result * PRIME + this.getPreviousGameMode();
        result = result * PRIME + (this.isDebug() ? 79 : 97);
        result = result * PRIME + (this.isFlat() ? 79 : 97);
        result = result * PRIME + this.getCopyMeta();
        result = result * PRIME + this.getPortalCooldown();
        result = result * PRIME + this.getSeaLevel();
        final java.lang.Object $dimension = this.getDimension();
        result = result * PRIME + ($dimension == null ? 43 : $dimension.hashCode());
        final java.lang.Object $worldName = this.getWorldName();
        result = result * PRIME + ($worldName == null ? 43 : $worldName.hashCode());
        final java.lang.Object $levelType = this.getLevelType();
        result = result * PRIME + ($levelType == null ? 43 : $levelType.hashCode());
        final java.lang.Object $deathLocation = this.getDeathLocation();
        result = result * PRIME + ($deathLocation == null ? 43 : $deathLocation.hashCode());
        return result;
    }
}
