/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class KeepAlive
extends DefinedPacket {
    private long randomId;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.randomId = protocolVersion >= 340 ? buf.readLong() : (long)KeepAlive.readVarInt(buf);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 340) {
            buf.writeLong(this.randomId);
        } else {
            KeepAlive.writeVarInt((int)this.randomId, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public long getRandomId() {
        return this.randomId;
    }

    @Generated
    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }

    @Override
    @Generated
    public String toString() {
        return "KeepAlive(randomId=" + this.getRandomId() + ")";
    }

    @Generated
    public KeepAlive() {
    }

    @Generated
    public KeepAlive(long randomId) {
        this.randomId = randomId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeepAlive)) {
            return false;
        }
        KeepAlive other = (KeepAlive)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getRandomId() == other.getRandomId();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeepAlive;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $randomId = this.getRandomId();
        result = result * 59 + (int)($randomId >>> 32 ^ $randomId);
        return result;
    }
}

