/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class LongArrayTag
implements TypedTag {
    private long[] value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(24L);
        int length = input.readInt();
        limiter.countBytes(length, 8L);
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = input.readLong();
        }
        this.value = data;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull((Object)this.value, (Object)"long array value cannot be null");
        output.writeInt(this.value.length);
        for (long i : this.value) {
            output.writeLong(i);
        }
    }

    @Override
    public byte getId() {
        return 12;
    }

    @Generated
    public long[] getValue() {
        return this.value;
    }

    @Generated
    public void setValue(long[] value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongArrayTag)) {
            return false;
        }
        LongArrayTag other = (LongArrayTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getValue(), other.getValue());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LongArrayTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getValue());
        return result;
    }

    @Generated
    public String toString() {
        return "LongArrayTag(value=" + Arrays.toString(this.getValue()) + ")";
    }

    @Generated
    public LongArrayTag() {
    }

    @Generated
    public LongArrayTag(long[] value) {
        this.value = value;
    }
}

