// Generated by delombok at Tue Dec 16 19:35:27 UTC 2025
package net.md_5.bungee.api.event;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Cancellable;
import net.md_5.bungee.api.plugin.Event;

/**
 * Represents a player getting kicked from a server.
 */
public class ServerKickEvent extends Event implements Cancellable {
    /**
     * Cancelled status.
     */
    private boolean cancelled;
    /**
     * Player being kicked.
     */
    private final ProxiedPlayer player;
    /**
     * The server the player was kicked from, should be used in preference to
     * {@link ProxiedPlayer#getServer()}.
     */
    private final ServerInfo kickedFrom;
    /**
     * Kick reason.
     */
    private BaseComponent reason;
    /**
     * Server to send player to if this event is cancelled.
     */
    private ServerInfo cancelServer;
    /**
     * State in which the kick occured.
     */
    private State state;


    public enum State {
        CONNECTING, CONNECTED, UNKNOWN;
    }

    @Deprecated
    public ServerKickEvent(ProxiedPlayer player, BaseComponent[] kickReasonComponent, ServerInfo cancelServer) {
        this(player, kickReasonComponent, cancelServer, State.UNKNOWN);
    }

    @Deprecated
    public ServerKickEvent(ProxiedPlayer player, BaseComponent[] kickReasonComponent, ServerInfo cancelServer, State state) {
        this(player, player.getServer().getInfo(), kickReasonComponent, cancelServer, state);
    }

    @Deprecated
    public ServerKickEvent(ProxiedPlayer player, ServerInfo kickedFrom, BaseComponent[] kickReasonComponent, ServerInfo cancelServer, State state) {
        this(player, kickedFrom, TextComponent.fromArray(kickReasonComponent), cancelServer, state);
    }

    public ServerKickEvent(ProxiedPlayer player, ServerInfo kickedFrom, BaseComponent reason, ServerInfo cancelServer, State state) {
        this.player = player;
        this.kickedFrom = kickedFrom;
        this.reason = reason;
        this.cancelServer = cancelServer;
        this.state = state;
    }

    /**
     * @return the kick reason
     * @deprecated use component methods instead
     */
    @Deprecated
    public String getKickReason() {
        return BaseComponent.toLegacyText(getReason());
    }

    /**
     * @param reason the kick reason
     * @deprecated use component methods instead
     */
    @Deprecated
    public void setKickReason(String reason) {
        this.setReason(TextComponent.fromLegacy(reason));
    }

    /**
     * @return the kick reason
     * @deprecated use single component methods instead
     */
    @Deprecated
    public BaseComponent[] getKickReasonComponent() {
        return new BaseComponent[] {getReason()};
    }

    /**
     * @param kickReasonComponent the kick reason
     * @deprecated use single component methods instead
     */
    @Deprecated
    public void setKickReasonComponent(BaseComponent[] kickReasonComponent) {
        this.setReason(TextComponent.fromArray(kickReasonComponent));
    }

    /**
     * Cancelled status.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    /**
     * Player being kicked.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProxiedPlayer getPlayer() {
        return this.player;
    }

    /**
     * The server the player was kicked from, should be used in preference to
     * {@link ProxiedPlayer#getServer()}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerInfo getKickedFrom() {
        return this.kickedFrom;
    }

    /**
     * Kick reason.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent getReason() {
        return this.reason;
    }

    /**
     * Server to send player to if this event is cancelled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerInfo getCancelServer() {
        return this.cancelServer;
    }

    /**
     * State in which the kick occured.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public State getState() {
        return this.state;
    }

    /**
     * Cancelled status.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancelled(final boolean cancelled) {
        this.cancelled = cancelled;
    }

    /**
     * Kick reason.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReason(final BaseComponent reason) {
        this.reason = reason;
    }

    /**
     * Server to send player to if this event is cancelled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancelServer(final ServerInfo cancelServer) {
        this.cancelServer = cancelServer;
    }

    /**
     * State in which the kick occured.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setState(final State state) {
        this.state = state;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ServerKickEvent(cancelled=" + this.isCancelled() + ", player=" + this.getPlayer() + ", kickedFrom=" + this.getKickedFrom() + ", reason=" + this.getReason() + ", cancelServer=" + this.getCancelServer() + ", state=" + this.getState() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServerKickEvent)) return false;
        final ServerKickEvent other = (ServerKickEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.isCancelled() != other.isCancelled()) return false;
        final java.lang.Object this$player = this.getPlayer();
        final java.lang.Object other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) return false;
        final java.lang.Object this$kickedFrom = this.getKickedFrom();
        final java.lang.Object other$kickedFrom = other.getKickedFrom();
        if (this$kickedFrom == null ? other$kickedFrom != null : !this$kickedFrom.equals(other$kickedFrom)) return false;
        final java.lang.Object this$reason = this.getReason();
        final java.lang.Object other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
        final java.lang.Object this$cancelServer = this.getCancelServer();
        final java.lang.Object other$cancelServer = other.getCancelServer();
        if (this$cancelServer == null ? other$cancelServer != null : !this$cancelServer.equals(other$cancelServer)) return false;
        final java.lang.Object this$state = this.getState();
        final java.lang.Object other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ServerKickEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + (this.isCancelled() ? 79 : 97);
        final java.lang.Object $player = this.getPlayer();
        result = result * PRIME + ($player == null ? 43 : $player.hashCode());
        final java.lang.Object $kickedFrom = this.getKickedFrom();
        result = result * PRIME + ($kickedFrom == null ? 43 : $kickedFrom.hashCode());
        final java.lang.Object $reason = this.getReason();
        result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
        final java.lang.Object $cancelServer = this.getCancelServer();
        result = result * PRIME + ($cancelServer == null ? 43 : $cancelServer.hashCode());
        final java.lang.Object $state = this.getState();
        result = result * PRIME + ($state == null ? 43 : $state.hashCode());
        return result;
    }
}
