// Generated by delombok at Tue Dec 16 19:35:27 UTC 2025
package net.md_5.bungee.api.config;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

/**
 * Class representing the configuration of a server listener. Used for allowing
 * multiple listeners on different ports.
 */
public class ListenerInfo {
    /**
     * Host to bind to.
     */
    private final SocketAddress socketAddress;
    /**
     * Displayed MOTD.
     */
    private final String motd;
    /**
     * Max amount of slots displayed on the ping page.
     */
    private final int maxPlayers;
    /**
     * Number of players to be shown on the tab list.
     */
    private final int tabListSize;
    /**
     * List of servers in order of join attempt. First attempt is the first
     * element, second attempt is the next element, etc etc.
     */
    private final List<String> serverPriority;
    /**
     * Whether reconnect locations will be used, or else the user is simply
     * transferred to the default server on connect.
     */
    private final boolean forceDefault;
    /**
     * A list of host to server name mappings which will force a user to be
     * transferred depending on the host they connect to.
     */
    private final Map<String, String> forcedHosts;
    /**
     * The type of tab list to use
     */
    private final String tabListType;
    /**
     * Whether to set the local address when connecting to servers.
     */
    private final boolean setLocalAddress;
    /**
     * Whether to pass the ping through when we can reliably get the target
     * server (force default server).
     */
    private final boolean pingPassthrough;
    /**
     * What port to run udp query on.
     */
    private final int queryPort;
    /**
     * Whether to enable udp query.
     */
    private final boolean queryEnabled;
    /**
     * Whether to support HAProxy PROXY protocol.
     */
    private final boolean proxyProtocol;

    @Deprecated
    public ListenerInfo(InetSocketAddress host, String motd, int maxPlayers, int tabListSize, List<String> serverPriority, boolean forceDefault, Map<String, String> forcedHosts, String tabListType, boolean setLocalAddress, boolean pingPassthrough, int queryPort, boolean queryEnabled) {
        this(host, motd, maxPlayers, tabListSize, serverPriority, forceDefault, forcedHosts, tabListType, setLocalAddress, pingPassthrough, queryPort, queryEnabled, false);
    }

    /**
     * Gets the highest priority server to join.
     *
     * @return default server
     * @deprecated replaced by {@link #serverPriority}
     */
    @Deprecated
    public String getDefaultServer() {
        return serverPriority.get(0);
    }

    /**
     * Gets the second highest priority server to join, or else the highest
     * priority.
     *
     * @return fallback server
     * @deprecated replaced by {@link #serverPriority}
     */
    @Deprecated
    public String getFallbackServer() {
        return (serverPriority.size() > 1) ? serverPriority.get(1) : getDefaultServer();
    }

    /**
     * Gets the bind address as an InetSocketAddress if possible.
     *
     * @return bind host
     * @deprecated BungeeCord can listen via Unix domain sockets
     */
    @Deprecated
    public InetSocketAddress getHost() {
        return (InetSocketAddress) socketAddress;
    }

    /**
     * Host to bind to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    /**
     * Displayed MOTD.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMotd() {
        return this.motd;
    }

    /**
     * Max amount of slots displayed on the ping page.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    /**
     * Number of players to be shown on the tab list.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getTabListSize() {
        return this.tabListSize;
    }

    /**
     * List of servers in order of join attempt. First attempt is the first
     * element, second attempt is the next element, etc etc.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getServerPriority() {
        return this.serverPriority;
    }

    /**
     * Whether reconnect locations will be used, or else the user is simply
     * transferred to the default server on connect.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isForceDefault() {
        return this.forceDefault;
    }

    /**
     * A list of host to server name mappings which will force a user to be
     * transferred depending on the host they connect to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getForcedHosts() {
        return this.forcedHosts;
    }

    /**
     * The type of tab list to use
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTabListType() {
        return this.tabListType;
    }

    /**
     * Whether to set the local address when connecting to servers.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isSetLocalAddress() {
        return this.setLocalAddress;
    }

    /**
     * Whether to pass the ping through when we can reliably get the target
     * server (force default server).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isPingPassthrough() {
        return this.pingPassthrough;
    }

    /**
     * What port to run udp query on.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getQueryPort() {
        return this.queryPort;
    }

    /**
     * Whether to enable udp query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isQueryEnabled() {
        return this.queryEnabled;
    }

    /**
     * Whether to support HAProxy PROXY protocol.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isProxyProtocol() {
        return this.proxyProtocol;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListenerInfo)) return false;
        final ListenerInfo other = (ListenerInfo) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getMaxPlayers() != other.getMaxPlayers()) return false;
        if (this.getTabListSize() != other.getTabListSize()) return false;
        if (this.isForceDefault() != other.isForceDefault()) return false;
        if (this.isSetLocalAddress() != other.isSetLocalAddress()) return false;
        if (this.isPingPassthrough() != other.isPingPassthrough()) return false;
        if (this.getQueryPort() != other.getQueryPort()) return false;
        if (this.isQueryEnabled() != other.isQueryEnabled()) return false;
        if (this.isProxyProtocol() != other.isProxyProtocol()) return false;
        final java.lang.Object this$socketAddress = this.getSocketAddress();
        final java.lang.Object other$socketAddress = other.getSocketAddress();
        if (this$socketAddress == null ? other$socketAddress != null : !this$socketAddress.equals(other$socketAddress)) return false;
        final java.lang.Object this$motd = this.getMotd();
        final java.lang.Object other$motd = other.getMotd();
        if (this$motd == null ? other$motd != null : !this$motd.equals(other$motd)) return false;
        final java.lang.Object this$serverPriority = this.getServerPriority();
        final java.lang.Object other$serverPriority = other.getServerPriority();
        if (this$serverPriority == null ? other$serverPriority != null : !this$serverPriority.equals(other$serverPriority)) return false;
        final java.lang.Object this$forcedHosts = this.getForcedHosts();
        final java.lang.Object other$forcedHosts = other.getForcedHosts();
        if (this$forcedHosts == null ? other$forcedHosts != null : !this$forcedHosts.equals(other$forcedHosts)) return false;
        final java.lang.Object this$tabListType = this.getTabListType();
        final java.lang.Object other$tabListType = other.getTabListType();
        if (this$tabListType == null ? other$tabListType != null : !this$tabListType.equals(other$tabListType)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListenerInfo;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getMaxPlayers();
        result = result * PRIME + this.getTabListSize();
        result = result * PRIME + (this.isForceDefault() ? 79 : 97);
        result = result * PRIME + (this.isSetLocalAddress() ? 79 : 97);
        result = result * PRIME + (this.isPingPassthrough() ? 79 : 97);
        result = result * PRIME + this.getQueryPort();
        result = result * PRIME + (this.isQueryEnabled() ? 79 : 97);
        result = result * PRIME + (this.isProxyProtocol() ? 79 : 97);
        final java.lang.Object $socketAddress = this.getSocketAddress();
        result = result * PRIME + ($socketAddress == null ? 43 : $socketAddress.hashCode());
        final java.lang.Object $motd = this.getMotd();
        result = result * PRIME + ($motd == null ? 43 : $motd.hashCode());
        final java.lang.Object $serverPriority = this.getServerPriority();
        result = result * PRIME + ($serverPriority == null ? 43 : $serverPriority.hashCode());
        final java.lang.Object $forcedHosts = this.getForcedHosts();
        result = result * PRIME + ($forcedHosts == null ? 43 : $forcedHosts.hashCode());
        final java.lang.Object $tabListType = this.getTabListType();
        result = result * PRIME + ($tabListType == null ? 43 : $tabListType.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ListenerInfo(socketAddress=" + this.getSocketAddress() + ", motd=" + this.getMotd() + ", maxPlayers=" + this.getMaxPlayers() + ", tabListSize=" + this.getTabListSize() + ", serverPriority=" + this.getServerPriority() + ", forceDefault=" + this.isForceDefault() + ", forcedHosts=" + this.getForcedHosts() + ", tabListType=" + this.getTabListType() + ", setLocalAddress=" + this.isSetLocalAddress() + ", pingPassthrough=" + this.isPingPassthrough() + ", queryPort=" + this.getQueryPort() + ", queryEnabled=" + this.isQueryEnabled() + ", proxyProtocol=" + this.isProxyProtocol() + ")";
    }

    /**
     * Creates a new {@code ListenerInfo} instance.
     *
     * @param socketAddress Host to bind to.
     * @param motd Displayed MOTD.
     * @param maxPlayers Max amount of slots displayed on the ping page.
     * @param tabListSize Number of players to be shown on the tab list.
     * @param serverPriority List of servers in order of join attempt. First attempt is the first
     * element, second attempt is the next element, etc etc.
     * @param forceDefault Whether reconnect locations will be used, or else the user is simply
     * transferred to the default server on connect.
     * @param forcedHosts A list of host to server name mappings which will force a user to be
     * transferred depending on the host they connect to.
     * @param tabListType The type of tab list to use
     * @param setLocalAddress Whether to set the local address when connecting to servers.
     * @param pingPassthrough Whether to pass the ping through when we can reliably get the target
     * server (force default server).
     * @param queryPort What port to run udp query on.
     * @param queryEnabled Whether to enable udp query.
     * @param proxyProtocol Whether to support HAProxy PROXY protocol.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ListenerInfo(final SocketAddress socketAddress, final String motd, final int maxPlayers, final int tabListSize, final List<String> serverPriority, final boolean forceDefault, final Map<String, String> forcedHosts, final String tabListType, final boolean setLocalAddress, final boolean pingPassthrough, final int queryPort, final boolean queryEnabled, final boolean proxyProtocol) {
        this.socketAddress = socketAddress;
        this.motd = motd;
        this.maxPlayers = maxPlayers;
        this.tabListSize = tabListSize;
        this.serverPriority = serverPriority;
        this.forceDefault = forceDefault;
        this.forcedHosts = forcedHosts;
        this.tabListType = tabListType;
        this.setLocalAddress = setLocalAddress;
        this.pingPassthrough = pingPassthrough;
        this.queryPort = queryPort;
        this.queryEnabled = queryEnabled;
        this.proxyProtocol = proxyProtocol;
    }
}
