// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Locale;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class PluginMessage extends DefinedPacket {
    public static final String BUNGEE_CHANNEL_LEGACY = "BungeeCord";
    public static final String BUNGEE_CHANNEL_MODERN = "bungeecord:main";
    public static final Function<String, String> MODERNISE = new Function<String, String>() {
        @Override
        public String apply(String tag) {
            // Transform as per Bukkit
            if (tag.equals(PluginMessage.BUNGEE_CHANNEL_LEGACY)) {
                return PluginMessage.BUNGEE_CHANNEL_MODERN;
            }
            if (tag.equals(PluginMessage.BUNGEE_CHANNEL_MODERN)) {
                return PluginMessage.BUNGEE_CHANNEL_LEGACY;
            }
            // Code that gets to here is UNLIKELY to be viable on the Bukkit side of side things,
            // but we keep it anyway. It will eventually be enforced API side.
            if (tag.indexOf(':') != -1) {
                return tag;
            }
            return "legacy:" + tag.toLowerCase(Locale.ROOT);
        }
    };
    //
    private String tag;
    private byte[] data;
    /**
     * Allow this packet to be sent as an "extended" packet.
     */
    private boolean allowExtendedPacket = false;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        tag = (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) ? MODERNISE.apply(readString(buf)) : readString(buf, 20);
        int maxSize = (direction == ProtocolConstants.Direction.TO_SERVER) ? Short.MAX_VALUE : 1048576;
        Preconditions.checkArgument(buf.readableBytes() <= maxSize, "Payload too large");
        data = new byte[buf.readableBytes()];
        buf.readBytes(data);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString((protocolVersion >= ProtocolConstants.MINECRAFT_1_13) ? MODERNISE.apply(tag) : tag, buf);
        buf.writeBytes(data);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public DataInput getStream() {
        return new DataInputStream(new ByteArrayInputStream(data));
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTag() {
        return this.tag;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte[] getData() {
        return this.data;
    }

    /**
     * Allow this packet to be sent as an "extended" packet.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isAllowExtendedPacket() {
        return this.allowExtendedPacket;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTag(final String tag) {
        this.tag = tag;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setData(final byte[] data) {
        this.data = data;
    }

    /**
     * Allow this packet to be sent as an "extended" packet.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAllowExtendedPacket(final boolean allowExtendedPacket) {
        this.allowExtendedPacket = allowExtendedPacket;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PluginMessage(tag=" + this.getTag() + ", data=" + java.util.Arrays.toString(this.getData()) + ", allowExtendedPacket=" + this.isAllowExtendedPacket() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PluginMessage() {
    }

    /**
     * Creates a new {@code PluginMessage} instance.
     *
     * @param tag
     * @param data
     * @param allowExtendedPacket Allow this packet to be sent as an "extended" packet.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PluginMessage(final String tag, final byte[] data, final boolean allowExtendedPacket) {
        this.tag = tag;
        this.data = data;
        this.allowExtendedPacket = allowExtendedPacket;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PluginMessage)) return false;
        final PluginMessage other = (PluginMessage) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.isAllowExtendedPacket() != other.isAllowExtendedPacket()) return false;
        final java.lang.Object this$tag = this.getTag();
        final java.lang.Object other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) return false;
        if (!java.util.Arrays.equals(this.getData(), other.getData())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PluginMessage;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + (this.isAllowExtendedPacket() ? 79 : 97);
        final java.lang.Object $tag = this.getTag();
        result = result * PRIME + ($tag == null ? 43 : $tag.hashCode());
        result = result * PRIME + java.util.Arrays.hashCode(this.getData());
        return result;
    }
}
