// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.PlayerPublicKey;
import net.md_5.bungee.protocol.packet.PlayerListItem.Item;

public class PlayerListItemUpdate extends DefinedPacket {
    private EnumSet<Action> actions;
    private Item[] items;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        actions = readEnumSet(PlayerListItemUpdate.Action.class, buf);
        items = new Item[DefinedPacket.readVarInt(buf)];
        for (int i = 0; i < items.length; i++) {
            Item item = items[i] = new Item();
            item.setUuid(DefinedPacket.readUUID(buf));
            for (Action action : actions) {
                switch (action) {
                case ADD_PLAYER: 
                    item.username = DefinedPacket.readString(buf);
                    item.properties = DefinedPacket.readProperties(buf);
                    break;
                case INITIALIZE_CHAT: 
                    if (buf.readBoolean()) {
                        item.chatSessionId = readUUID(buf);
                        item.publicKey = new PlayerPublicKey(buf.readLong(), readArray(buf, 512), readArray(buf, 4096));
                    }
                    break;
                case UPDATE_GAMEMODE: 
                    item.gamemode = DefinedPacket.readVarInt(buf);
                    break;
                case UPDATE_LISTED: 
                    item.listed = buf.readBoolean();
                    break;
                case UPDATE_LATENCY: 
                    item.ping = DefinedPacket.readVarInt(buf);
                    break;
                case UPDATE_DISPLAY_NAME: 
                    if (buf.readBoolean()) {
                        item.displayName = DefinedPacket.readBaseComponent(buf, protocolVersion);
                    }
                    break;
                case UPDATE_LIST_ORDER: 
                    item.listOrder = DefinedPacket.readVarInt(buf);
                    break;
                case UPDATE_HAT: 
                    item.showHat = buf.readBoolean();
                    break;
                }
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        DefinedPacket.writeEnumSet(actions, PlayerListItemUpdate.Action.class, buf);
        DefinedPacket.writeVarInt(items.length, buf);
        for (Item item : items) {
            DefinedPacket.writeUUID(item.uuid, buf);
            for (Action action : actions) {
                switch (action) {
                case ADD_PLAYER: 
                    DefinedPacket.writeString(item.username, buf);
                    DefinedPacket.writeProperties(item.properties, buf);
                    break;
                case INITIALIZE_CHAT: 
                    buf.writeBoolean(item.chatSessionId != null);
                    if (item.chatSessionId != null) {
                        writeUUID(item.chatSessionId, buf);
                        buf.writeLong(item.publicKey.getExpiry());
                        writeArray(item.publicKey.getKey(), buf);
                        writeArray(item.publicKey.getSignature(), buf);
                    }
                    break;
                case UPDATE_GAMEMODE: 
                    DefinedPacket.writeVarInt(item.gamemode, buf);
                    break;
                case UPDATE_LISTED: 
                    buf.writeBoolean(item.listed);
                    break;
                case UPDATE_LATENCY: 
                    DefinedPacket.writeVarInt(item.ping, buf);
                    break;
                case UPDATE_DISPLAY_NAME: 
                    buf.writeBoolean(item.displayName != null);
                    if (item.displayName != null) {
                        DefinedPacket.writeBaseComponent(item.displayName, buf, protocolVersion);
                    }
                    break;
                case UPDATE_LIST_ORDER: 
                    DefinedPacket.writeVarInt(item.listOrder, buf);
                    break;
                case UPDATE_HAT: 
                    buf.writeBoolean(item.showHat);
                    break;
                }
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }


    public static enum Action {
        ADD_PLAYER, INITIALIZE_CHAT, UPDATE_GAMEMODE, UPDATE_LISTED, UPDATE_LATENCY, UPDATE_DISPLAY_NAME, UPDATE_LIST_ORDER, UPDATE_HAT;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EnumSet<Action> getActions() {
        return this.actions;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Item[] getItems() {
        return this.items;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setActions(final EnumSet<Action> actions) {
        this.actions = actions;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setItems(final Item[] items) {
        this.items = items;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PlayerListItemUpdate(actions=" + this.getActions() + ", items=" + java.util.Arrays.deepToString(this.getItems()) + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PlayerListItemUpdate() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PlayerListItemUpdate)) return false;
        final PlayerListItemUpdate other = (PlayerListItemUpdate) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$actions = this.getActions();
        final java.lang.Object other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !this$actions.equals(other$actions)) return false;
        if (!java.util.Arrays.deepEquals(this.getItems(), other.getItems())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PlayerListItemUpdate;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $actions = this.getActions();
        result = result * PRIME + ($actions == null ? 43 : $actions.hashCode());
        result = result * PRIME + java.util.Arrays.deepHashCode(this.getItems());
        return result;
    }
}
