/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.chat;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Locale;
import lombok.Generated;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ClickEventCustom;
import net.md_5.bungee.api.dialog.chat.ShowDialogClickEvent;

public class ClickEventSerializer {
    public static final ClickEventSerializer OLD = new ClickEventSerializer(ClickType.OLD);
    public static final ClickEventSerializer NEW = new ClickEventSerializer(ClickType.NEW);
    public static final ClickEventSerializer DIALOG = new ClickEventSerializer(ClickType.DIALOG);
    private final ClickType type;

    public ClickEvent deserialize(JsonObject clickEvent, JsonDeserializationContext context) throws JsonParseException {
        ClickEvent.Action action = ClickEvent.Action.valueOf((String)clickEvent.get(this.type == ClickType.DIALOG ? "type" : "action").getAsString().toUpperCase(Locale.ROOT));
        switch (this.type) {
            case NEW: 
            case DIALOG: {
                switch (action) {
                    case OPEN_URL: {
                        return new ClickEvent(action, clickEvent.get("url").getAsString());
                    }
                    case RUN_COMMAND: 
                    case SUGGEST_COMMAND: {
                        return new ClickEvent(action, clickEvent.get("command").getAsString());
                    }
                    case CHANGE_PAGE: {
                        int page = clickEvent.get("page").getAsInt();
                        Preconditions.checkArgument((page >= 0 ? 1 : 0) != 0, (Object)"Page number has to be positive");
                        return new ClickEvent(action, Integer.toString(page));
                    }
                    case SHOW_DIALOG: {
                        return (ClickEvent)context.deserialize(clickEvent.get("dialog"), ShowDialogClickEvent.class);
                    }
                    case CUSTOM: {
                        return new ClickEventCustom(clickEvent.get("id").getAsString(), clickEvent.has("payload") ? clickEvent.get("payload").getAsString() : null);
                    }
                }
                return new ClickEvent(action, clickEvent.has("value") ? clickEvent.get("value").getAsString() : "");
            }
            case OLD: {
                return new ClickEvent(action, clickEvent.has("value") ? clickEvent.get("value").getAsString() : "");
            }
        }
        throw new IllegalArgumentException("Unknown serializer type");
    }

    public JsonElement serialize(ClickEvent src, JsonSerializationContext context) {
        JsonObject clickEvent = new JsonObject();
        String actionName = src.getAction().toString().toLowerCase(Locale.ROOT);
        clickEvent.addProperty(this.type == ClickType.DIALOG ? "type" : "action", actionName.toLowerCase(Locale.ROOT));
        block0 : switch (this.type) {
            case NEW: 
            case DIALOG: {
                ClickEvent.Action action = ClickEvent.Action.valueOf((String)actionName.toUpperCase(Locale.ROOT));
                switch (action) {
                    case OPEN_URL: {
                        clickEvent.addProperty("url", src.getValue());
                        break;
                    }
                    case RUN_COMMAND: 
                    case SUGGEST_COMMAND: {
                        clickEvent.addProperty("command", src.getValue());
                        break;
                    }
                    case CHANGE_PAGE: {
                        clickEvent.addProperty("page", (Number)Integer.parseInt(src.getValue()));
                        break;
                    }
                    case SHOW_DIALOG: {
                        clickEvent.add("dialog", context.serialize((Object)src));
                        break;
                    }
                    case CUSTOM: {
                        ClickEventCustom custom = (ClickEventCustom)src;
                        clickEvent.addProperty("id", custom.getValue());
                        if (custom.getPayload() == null) break block0;
                        clickEvent.addProperty("payload", custom.getPayload());
                        break;
                    }
                    default: {
                        clickEvent.addProperty("value", src.getValue());
                        break;
                    }
                }
                break;
            }
            case OLD: {
                clickEvent.addProperty("value", src.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown serializer type");
            }
        }
        return clickEvent;
    }

    @Generated
    public ClickEventSerializer(ClickType type) {
        this.type = type;
    }

    @Generated
    public ClickType getType() {
        return this.type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClickEventSerializer)) {
            return false;
        }
        ClickEventSerializer other = (ClickEventSerializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClickType this$type = this.getType();
        ClickType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClickEventSerializer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClickType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClickEventSerializer(type=" + (Object)((Object)this.getType()) + ")";
    }

    public static enum ClickType {
        OLD,
        NEW,
        DIALOG;

    }
}

