// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.ChatSerializer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.util.Either;
import net.md_5.bungee.protocol.util.TagUtil;

public class ShowDialog extends DefinedPacket {
    protected Either<Integer, Dialog> dialog;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int id = readVarInt(buf);
        if (id == 0) {
            dialog = Either.right(readDialog(buf, direction, protocolVersion));
        } else {
            dialog = Either.left(id);
        }
    }

    protected static Dialog readDialog(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        TypedTag nbt = (TypedTag) readTag(buf, protocolVersion);
        JsonElement json = TagUtil.toJson(nbt);
        return ChatSerializer.forVersion(protocolVersion).getDialogSerializer().deserialize(json);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (dialog.isLeft()) {
            writeVarInt(dialog.getLeft(), buf);
        } else {
            writeVarInt(0, buf);
            writeDialog(dialog.getRight(), buf, direction, protocolVersion);
        }
    }

    protected static void writeDialog(Dialog dialog, ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        JsonElement json = ChatSerializer.forVersion(protocolVersion).getDialogSerializer().toJson(dialog);
        TypedTag nbt = TagUtil.fromJson(json);
        writeTag(nbt, buf, protocolVersion);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Either<Integer, Dialog> getDialog() {
        return this.dialog;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDialog(final Either<Integer, Dialog> dialog) {
        this.dialog = dialog;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ShowDialog(dialog=" + this.getDialog() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ShowDialog() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ShowDialog(final Either<Integer, Dialog> dialog) {
        this.dialog = dialog;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ShowDialog)) return false;
        final ShowDialog other = (ShowDialog) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$dialog = this.getDialog();
        final java.lang.Object other$dialog = other.getDialog();
        if (this$dialog == null ? other$dialog != null : !this$dialog.equals(other$dialog)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ShowDialog;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $dialog = this.getDialog();
        result = result * PRIME + ($dialog == null ? 43 : $dialog.hashCode());
        return result;
    }
}
