// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class DisconnectReportDetails extends DefinedPacket {
    private Map<String, String> details;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int len = readVarInt(buf);
        Preconditions.checkArgument(len <= 32, "Too many details");
        details = new HashMap<>();
        for (int i = 0; i < len; i++) {
            details.put(readString(buf, 128), readString(buf, 4096));
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        Preconditions.checkArgument(details.size() <= 32, "Too many details");
        writeVarInt(details.size(), buf);
        for (Map.Entry<String, String> detail : details.entrySet()) {
            writeString(detail.getKey(), buf, 128);
            writeString(detail.getValue(), buf, 4096);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getDetails() {
        return this.details;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDetails(final Map<String, String> details) {
        this.details = details;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DisconnectReportDetails(details=" + this.getDetails() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DisconnectReportDetails() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DisconnectReportDetails(final Map<String, String> details) {
        this.details = details;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DisconnectReportDetails)) return false;
        final DisconnectReportDetails other = (DisconnectReportDetails) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$details = this.getDetails();
        final java.lang.Object other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DisconnectReportDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $details = this.getDetails();
        result = result * PRIME + ($details == null ? 43 : $details.hashCode());
        return result;
    }
}
