// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.data;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ChatChain extends DefinedPacket {
    private List<ChainLink> seen;
    private List<ChainLink> received;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        seen = readLinks(buf);
        if (buf.readBoolean()) {
            received = readLinks(buf);
        }
    }

    private static List<ChainLink> readLinks(ByteBuf buf) {
        int cnt = readVarInt(buf);
        Preconditions.checkArgument(cnt <= 5, "Too many entries");
        List<ChainLink> chain = new LinkedList<>();
        for (int i = 0; i < cnt; i++) {
            chain.add(new ChainLink(readUUID(buf), readArray(buf)));
        }
        return chain;
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeLinks(seen, buf);
        if (received != null) {
            buf.writeBoolean(true);
            writeLinks(received, buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    private static void writeLinks(List<ChainLink> links, ByteBuf buf) {
        writeVarInt(links.size(), buf);
        for (ChainLink link : links) {
            writeUUID(link.sender, buf);
            writeArray(link.signature, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException("Not supported.");
    }


    public static class ChainLink {
        private final UUID sender;
        private final byte[] signature;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ChainLink(final UUID sender, final byte[] signature) {
            this.sender = sender;
            this.signature = signature;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public UUID getSender() {
            return this.sender;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public byte[] getSignature() {
            return this.signature;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ChatChain.ChainLink)) return false;
            final ChatChain.ChainLink other = (ChatChain.ChainLink) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$sender = this.getSender();
            final java.lang.Object other$sender = other.getSender();
            if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) return false;
            if (!java.util.Arrays.equals(this.getSignature(), other.getSignature())) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ChatChain.ChainLink;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $sender = this.getSender();
            result = result * PRIME + ($sender == null ? 43 : $sender.hashCode());
            result = result * PRIME + java.util.Arrays.hashCode(this.getSignature());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ChatChain.ChainLink(sender=" + this.getSender() + ", signature=" + java.util.Arrays.toString(this.getSignature()) + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<ChainLink> getSeen() {
        return this.seen;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<ChainLink> getReceived() {
        return this.received;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSeen(final List<ChainLink> seen) {
        this.seen = seen;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReceived(final List<ChainLink> received) {
        this.received = received;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ChatChain(seen=" + this.getSeen() + ", received=" + this.getReceived() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ChatChain() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ChatChain(final List<ChainLink> seen, final List<ChainLink> received) {
        this.seen = seen;
        this.received = received;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ChatChain)) return false;
        final ChatChain other = (ChatChain) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$seen = this.getSeen();
        final java.lang.Object other$seen = other.getSeen();
        if (this$seen == null ? other$seen != null : !this$seen.equals(other$seen)) return false;
        final java.lang.Object this$received = this.getReceived();
        final java.lang.Object other$received = other.getReceived();
        if (this$received == null ? other$received != null : !this$received.equals(other$received)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ChatChain;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $seen = this.getSeen();
        result = result * PRIME + ($seen == null ? 43 : $seen.hashCode());
        final java.lang.Object $received = this.getReceived();
        result = result * PRIME + ($received == null ? 43 : $received.hashCode());
        return result;
    }
}
