package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.util.Either;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ShowDialogDirect extends ShowDialog
{

    public ShowDialogDirect(Dialog dialog)
    {
        super( Either.right( dialog ) );
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion)
    {
        dialog = Either.right( readDialog( buf, direction, protocolVersion ) );
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion)
    {
        writeDialog( dialog.getRight(), buf, direction, protocolVersion );
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception
    {
        handler.handle( this );
    }
}
