// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.util;

import java.util.function.Function;

public final class Either<L, R> {
    private final L left;
    private final R right;

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Either<>(left, null);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Either<>(null, right);
    }

    public L getLeftOrCompute(Function<R, L> function) {
        if (isLeft()) {
            return left;
        } else {
            return function.apply(right);
        }
    }

    public R getRightOrCompute(Function<L, R> function) {
        if (isRight()) {
            return right;
        } else {
            return function.apply(left);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public L getLeft() {
        return this.left;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public R getRight() {
        return this.right;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Either)) return false;
        final Either<?, ?> other = (Either<?, ?>) o;
        final java.lang.Object this$left = this.getLeft();
        final java.lang.Object other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) return false;
        final java.lang.Object this$right = this.getRight();
        final java.lang.Object other$right = other.getRight();
        if (this$right == null ? other$right != null : !this$right.equals(other$right)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $left = this.getLeft();
        result = result * PRIME + ($left == null ? 43 : $left.hashCode());
        final java.lang.Object $right = this.getRight();
        result = result * PRIME + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Either(left=" + this.getLeft() + ", right=" + this.getRight() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Either(final L left, final R right) {
        this.left = left;
        this.right = right;
    }
}
