// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class Title extends DefinedPacket {
    private Action action;
    // TITLE & SUBTITLE
    private BaseComponent text;
    // TIMES
    private int fadeIn;
    private int stay;
    private int fadeOut;

    public Title(Action action) {
        this.action = action;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_17) {
            text = readBaseComponent(buf, protocolVersion);
            return;
        }
        int index = readVarInt(buf);
        // If we're working on 1.10 or lower, increment the value of the index so we pull out the correct value.
        if (protocolVersion <= ProtocolConstants.MINECRAFT_1_10 && index >= 2) {
            index++;
        }
        action = Action.values()[index];
        switch (action) {
        case TITLE: 
        case SUBTITLE: 
        case ACTIONBAR: 
            text = readBaseComponent(buf, protocolVersion);
            break;
        case TIMES: 
            fadeIn = buf.readInt();
            stay = buf.readInt();
            fadeOut = buf.readInt();
            break;
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_17) {
            writeBaseComponent(text, buf, protocolVersion);
            return;
        }
        int index = action.ordinal();
        // If we're working on 1.10 or lower, increment the value of the index so we pull out the correct value.
        if (protocolVersion <= ProtocolConstants.MINECRAFT_1_10 && index >= 2) {
            index--;
        }
        writeVarInt(index, buf);
        switch (action) {
        case TITLE: 
        case SUBTITLE: 
        case ACTIONBAR: 
            writeBaseComponent(text, buf, protocolVersion);
            break;
        case TIMES: 
            buf.writeInt(fadeIn);
            buf.writeInt(stay);
            buf.writeInt(fadeOut);
            break;
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }


    public static enum Action {
        TITLE, SUBTITLE, ACTIONBAR, TIMES, CLEAR, RESET;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Action getAction() {
        return this.action;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent getText() {
        return this.text;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getFadeIn() {
        return this.fadeIn;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getStay() {
        return this.stay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getFadeOut() {
        return this.fadeOut;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAction(final Action action) {
        this.action = action;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setText(final BaseComponent text) {
        this.text = text;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFadeIn(final int fadeIn) {
        this.fadeIn = fadeIn;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStay(final int stay) {
        this.stay = stay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFadeOut(final int fadeOut) {
        this.fadeOut = fadeOut;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Title(action=" + this.getAction() + ", text=" + this.getText() + ", fadeIn=" + this.getFadeIn() + ", stay=" + this.getStay() + ", fadeOut=" + this.getFadeOut() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Title() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Title)) return false;
        final Title other = (Title) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getFadeIn() != other.getFadeIn()) return false;
        if (this.getStay() != other.getStay()) return false;
        if (this.getFadeOut() != other.getFadeOut()) return false;
        final java.lang.Object this$action = this.getAction();
        final java.lang.Object other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) return false;
        final java.lang.Object this$text = this.getText();
        final java.lang.Object other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Title;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getFadeIn();
        result = result * PRIME + this.getStay();
        result = result * PRIME + this.getFadeOut();
        final java.lang.Object $action = this.getAction();
        result = result * PRIME + ($action == null ? 43 : $action.hashCode());
        final java.lang.Object $text = this.getText();
        result = result * PRIME + ($text == null ? 43 : $text.hashCode());
        return result;
    }
}
