// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.Property;

public class LoginSuccess extends DefinedPacket {
    private UUID uuid;
    private String username;
    private Property[] properties;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            uuid = readUUID(buf);
        } else {
            uuid = UUID.fromString(readString(buf));
        }
        username = readString(buf);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19) {
            properties = readProperties(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5 && protocolVersion < ProtocolConstants.MINECRAFT_1_21_2) {
            // Whether the client should disconnect on its own if it receives invalid data from the server
            buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
            writeUUID(uuid, buf);
        } else {
            writeString(uuid.toString(), buf);
        }
        writeString(username, buf);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19) {
            writeProperties(properties, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5 && protocolVersion < ProtocolConstants.MINECRAFT_1_21_2) {
            // Whether the client should disconnect on its own if it receives invalid data from the server
            // Vanilla sends true so we also send true
            buf.writeBoolean(true);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUsername() {
        return this.username;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Property[] getProperties() {
        return this.properties;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUuid(final UUID uuid) {
        this.uuid = uuid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsername(final String username) {
        this.username = username;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProperties(final Property[] properties) {
        this.properties = properties;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LoginSuccess(uuid=" + this.getUuid() + ", username=" + this.getUsername() + ", properties=" + java.util.Arrays.deepToString(this.getProperties()) + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LoginSuccess() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LoginSuccess(final UUID uuid, final String username, final Property[] properties) {
        this.uuid = uuid;
        this.username = username;
        this.properties = properties;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LoginSuccess)) return false;
        final LoginSuccess other = (LoginSuccess) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$uuid = this.getUuid();
        final java.lang.Object other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) return false;
        final java.lang.Object this$username = this.getUsername();
        final java.lang.Object other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) return false;
        if (!java.util.Arrays.deepEquals(this.getProperties(), other.getProperties())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LoginSuccess;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $uuid = this.getUuid();
        result = result * PRIME + ($uuid == null ? 43 : $uuid.hashCode());
        final java.lang.Object $username = this.getUsername();
        result = result * PRIME + ($username == null ? 43 : $username.hashCode());
        result = result * PRIME + java.util.Arrays.deepHashCode(this.getProperties());
        return result;
    }
}
