// Generated by delombok at Tue Dec 16 19:35:15 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.ChatChain;
import net.md_5.bungee.protocol.data.SeenMessages;

public class ClientChat extends DefinedPacket {
    private String message;
    private long timestamp;
    private long salt;
    private byte[] signature;
    private boolean signedPreview;
    private ChatChain chain;
    private SeenMessages seenMessages;
    private byte checksum;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        message = readString(buf, 256);
        timestamp = buf.readLong();
        salt = buf.readLong();
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_3) {
            if (buf.readBoolean()) {
                signature = new byte[256];
                buf.readBytes(signature);
            }
        } else {
            signature = readArray(buf);
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_19_3) {
            signedPreview = buf.readBoolean();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_3) {
            seenMessages = new SeenMessages();
            seenMessages.read(buf, direction, protocolVersion);
        } else if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_1) {
            chain = new ChatChain();
            chain.read(buf, direction, protocolVersion);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_5) {
            checksum = buf.readByte();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString(message, buf);
        buf.writeLong(timestamp);
        buf.writeLong(salt);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_3) {
            buf.writeBoolean(signature != null);
            if (signature != null) {
                buf.writeBytes(signature);
            }
        } else {
            writeArray(signature, buf);
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_19_3) {
            buf.writeBoolean(signedPreview);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_3) {
            seenMessages.write(buf, direction, protocolVersion);
        } else if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_1) {
            chain.write(buf, direction, protocolVersion);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_5) {
            buf.writeByte(checksum);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMessage() {
        return this.message;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long getSalt() {
        return this.salt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte[] getSignature() {
        return this.signature;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isSignedPreview() {
        return this.signedPreview;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ChatChain getChain() {
        return this.chain;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SeenMessages getSeenMessages() {
        return this.seenMessages;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getChecksum() {
        return this.checksum;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMessage(final String message) {
        this.message = message;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTimestamp(final long timestamp) {
        this.timestamp = timestamp;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSalt(final long salt) {
        this.salt = salt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSignature(final byte[] signature) {
        this.signature = signature;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSignedPreview(final boolean signedPreview) {
        this.signedPreview = signedPreview;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChain(final ChatChain chain) {
        this.chain = chain;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSeenMessages(final SeenMessages seenMessages) {
        this.seenMessages = seenMessages;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChecksum(final byte checksum) {
        this.checksum = checksum;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ClientChat(message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ", salt=" + this.getSalt() + ", signature=" + java.util.Arrays.toString(this.getSignature()) + ", signedPreview=" + this.isSignedPreview() + ", chain=" + this.getChain() + ", seenMessages=" + this.getSeenMessages() + ", checksum=" + this.getChecksum() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClientChat() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClientChat(final String message, final long timestamp, final long salt, final byte[] signature, final boolean signedPreview, final ChatChain chain, final SeenMessages seenMessages, final byte checksum) {
        this.message = message;
        this.timestamp = timestamp;
        this.salt = salt;
        this.signature = signature;
        this.signedPreview = signedPreview;
        this.chain = chain;
        this.seenMessages = seenMessages;
        this.checksum = checksum;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ClientChat)) return false;
        final ClientChat other = (ClientChat) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getTimestamp() != other.getTimestamp()) return false;
        if (this.getSalt() != other.getSalt()) return false;
        if (this.isSignedPreview() != other.isSignedPreview()) return false;
        if (this.getChecksum() != other.getChecksum()) return false;
        final java.lang.Object this$message = this.getMessage();
        final java.lang.Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
        if (!java.util.Arrays.equals(this.getSignature(), other.getSignature())) return false;
        final java.lang.Object this$chain = this.getChain();
        final java.lang.Object other$chain = other.getChain();
        if (this$chain == null ? other$chain != null : !this$chain.equals(other$chain)) return false;
        final java.lang.Object this$seenMessages = this.getSeenMessages();
        final java.lang.Object other$seenMessages = other.getSeenMessages();
        if (this$seenMessages == null ? other$seenMessages != null : !this$seenMessages.equals(other$seenMessages)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ClientChat;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final long $timestamp = this.getTimestamp();
        result = result * PRIME + (int) ($timestamp >>> 32 ^ $timestamp);
        final long $salt = this.getSalt();
        result = result * PRIME + (int) ($salt >>> 32 ^ $salt);
        result = result * PRIME + (this.isSignedPreview() ? 79 : 97);
        result = result * PRIME + this.getChecksum();
        final java.lang.Object $message = this.getMessage();
        result = result * PRIME + ($message == null ? 43 : $message.hashCode());
        result = result * PRIME + java.util.Arrays.hashCode(this.getSignature());
        final java.lang.Object $chain = this.getChain();
        result = result * PRIME + ($chain == null ? 43 : $chain.hashCode());
        final java.lang.Object $seenMessages = this.getSeenMessages();
        result = result * PRIME + ($seenMessages == null ? 43 : $seenMessages.hashCode());
        return result;
    }
}
