// Generated by delombok at Tue Dec 16 19:34:32 UTC 2025
package net.md_5.bungee.api.dialog.input;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;

/**
 * Represents a number slider input.
 */
public class NumberRangeInput extends DialogInput {
    /**
     * The width of the input (default: 200, minimum: 1, maximum: 1024).
     */
    private Integer width;
    /**
     * The label of the slider.
     */
    @NonNull
    private BaseComponent label;
    /**
     * A translate key used to display the label value (default:
     * options.generic_value).
     */
    private String labelFormat;
    /**
     * The start position of the slider (leftmost position).
     */
    private float start;
    /**
     * The end position of the slider (rightmost position).
     */
    private float end;
    /**
     * The steps in which the input will be increased or decreased, or null if
     * no specific steps.
     */
    private Float step;
    /**
     * The initial value of number input, or null to fall back to the middle.
     */
    private Float initial;

    public NumberRangeInput(@NonNull String key, @NonNull BaseComponent label, float start, float end) {
        this(key, null, label, "options.generic_value", start, end, null, null);
        if (key == null) {
            throw new java.lang.NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
    }

    public NumberRangeInput(@NonNull String key, @NonNull BaseComponent label, float start, float end, Float step) {
        this(key, null, label, "options.generic_value", start, end, step, null);
        if (key == null) {
            throw new java.lang.NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
    }

    public NumberRangeInput(@NonNull String key, @NonNull BaseComponent label, float start, float end, Float step, Float initial) {
        this(key, null, label, "options.generic_value", start, end, step, initial);
        if (key == null) {
            throw new java.lang.NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
    }

    public NumberRangeInput(@NonNull String key, Integer width, @NonNull BaseComponent label, String labelFormat, float start, float end, Float step, Float initial) {
        super("minecraft:number_range", key);
        if (key == null) {
            throw new java.lang.NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        width(width);
        this.label = label;
        this.labelFormat = labelFormat;
        this.start = start;
        this.end = end;
        step(step);
        initial(initial);
    }

    public NumberRangeInput width(Integer width) {
        Preconditions.checkArgument(width == null || (width >= 1 && width <= 1024), "with must be between 1 and 1024");
        this.width = width;
        return this;
    }

    public NumberRangeInput step(Float step) {
        Preconditions.checkArgument(step == null || step > 0, "step must be null or greater than zero");
        this.step = step;
        return this;
    }

    public NumberRangeInput initial(Float initial) {
        // we need to calculate if the initial value is between start and end, regardless of the order
        float min = Math.min(start, end);
        float max = Math.max(start, end);
        Preconditions.checkArgument(initial == null || (initial >= min && initial <= max), "initial must be null or between start and end");
        this.initial = initial;
        return this;
    }

    /**
     * The width of the input (default: 200, minimum: 1, maximum: 1024).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer width() {
        return this.width;
    }

    /**
     * The label of the slider.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent label() {
        return this.label;
    }

    /**
     * A translate key used to display the label value (default:
     * options.generic_value).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String labelFormat() {
        return this.labelFormat;
    }

    /**
     * The start position of the slider (leftmost position).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public float start() {
        return this.start;
    }

    /**
     * The end position of the slider (rightmost position).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public float end() {
        return this.end;
    }

    /**
     * The steps in which the input will be increased or decreased, or null if
     * no specific steps.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Float step() {
        return this.step;
    }

    /**
     * The initial value of number input, or null to fall back to the middle.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Float initial() {
        return this.initial;
    }

    /**
     * The label of the slider.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NumberRangeInput label(@NonNull final BaseComponent label) {
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    /**
     * A translate key used to display the label value (default:
     * options.generic_value).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NumberRangeInput labelFormat(final String labelFormat) {
        this.labelFormat = labelFormat;
        return this;
    }

    /**
     * The start position of the slider (leftmost position).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NumberRangeInput start(final float start) {
        this.start = start;
        return this;
    }

    /**
     * The end position of the slider (rightmost position).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NumberRangeInput end(final float end) {
        this.end = end;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "NumberRangeInput(super=" + super.toString() + ", width=" + this.width() + ", label=" + this.label() + ", labelFormat=" + this.labelFormat() + ", start=" + this.start() + ", end=" + this.end() + ", step=" + this.step() + ", initial=" + this.initial() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof NumberRangeInput)) return false;
        final NumberRangeInput other = (NumberRangeInput) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        if (java.lang.Float.compare(this.start(), other.start()) != 0) return false;
        if (java.lang.Float.compare(this.end(), other.end()) != 0) return false;
        final java.lang.Object this$width = this.width();
        final java.lang.Object other$width = other.width();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) return false;
        final java.lang.Object this$step = this.step();
        final java.lang.Object other$step = other.step();
        if (this$step == null ? other$step != null : !this$step.equals(other$step)) return false;
        final java.lang.Object this$initial = this.initial();
        final java.lang.Object other$initial = other.initial();
        if (this$initial == null ? other$initial != null : !this$initial.equals(other$initial)) return false;
        final java.lang.Object this$label = this.label();
        final java.lang.Object other$label = other.label();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
        final java.lang.Object this$labelFormat = this.labelFormat();
        final java.lang.Object other$labelFormat = other.labelFormat();
        if (this$labelFormat == null ? other$labelFormat != null : !this$labelFormat.equals(other$labelFormat)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof NumberRangeInput;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = result * PRIME + java.lang.Float.floatToIntBits(this.start());
        result = result * PRIME + java.lang.Float.floatToIntBits(this.end());
        final java.lang.Object $width = this.width();
        result = result * PRIME + ($width == null ? 43 : $width.hashCode());
        final java.lang.Object $step = this.step();
        result = result * PRIME + ($step == null ? 43 : $step.hashCode());
        final java.lang.Object $initial = this.initial();
        result = result * PRIME + ($initial == null ? 43 : $initial.hashCode());
        final java.lang.Object $label = this.label();
        result = result * PRIME + ($label == null ? 43 : $label.hashCode());
        final java.lang.Object $labelFormat = this.labelFormat();
        result = result * PRIME + ($labelFormat == null ? 43 : $labelFormat.hashCode());
        return result;
    }
}
