// Generated by delombok at Tue Dec 16 19:35:27 UTC 2025
package net.md_5.bungee.api.plugin;

import com.google.common.base.Preconditions;
import net.md_5.bungee.api.CommandSender;

/**
 * A command that can be executed by a {@link CommandSender}.
 */
public abstract class Command {
    private final String name;
    private final String permission;
    private final String[] aliases;
    private String permissionMessage;

    /**
     * Construct a new command with no permissions or aliases.
     *
     * @param name the name of this command
     */
    public Command(String name) {
        this(name, null);
    }

    /**
     * Construct a new command.
     *
     * @param name primary name of this command
     * @param permission the permission node required to execute this command,
     * null or empty string allows it to be executed by everyone
     * @param aliases aliases which map back to this command
     */
    public Command(String name, String permission, String... aliases) {
        Preconditions.checkArgument(name != null, "name");
        this.name = name;
        this.permission = permission;
        this.aliases = aliases;
        this.permissionMessage = null;
    }

    /**
     * Execute this command with the specified sender and arguments.
     *
     * @param sender the executor of this command
     * @param args arguments used to invoke this command
     */
    public abstract void execute(CommandSender sender, String[] args);

    /**
     * Check if this command can be executed by the given sender.
     *
     * @param sender the sender to check
     * @return whether the sender can execute this
     */
    public boolean hasPermission(CommandSender sender) {
        return permission == null || permission.isEmpty() || sender.hasPermission(permission);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPermission() {
        return this.permission;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String[] getAliases() {
        return this.aliases;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPermissionMessage() {
        return this.permissionMessage;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Command)) return false;
        final Command other = (Command) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$permission = this.getPermission();
        final java.lang.Object other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !this$permission.equals(other$permission)) return false;
        if (!java.util.Arrays.deepEquals(this.getAliases(), other.getAliases())) return false;
        final java.lang.Object this$permissionMessage = this.getPermissionMessage();
        final java.lang.Object other$permissionMessage = other.getPermissionMessage();
        if (this$permissionMessage == null ? other$permissionMessage != null : !this$permissionMessage.equals(other$permissionMessage)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Command;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $permission = this.getPermission();
        result = result * PRIME + ($permission == null ? 43 : $permission.hashCode());
        result = result * PRIME + java.util.Arrays.deepHashCode(this.getAliases());
        final java.lang.Object $permissionMessage = this.getPermissionMessage();
        result = result * PRIME + ($permissionMessage == null ? 43 : $permissionMessage.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Command(name=" + this.getName() + ", permission=" + this.getPermission() + ", aliases=" + java.util.Arrays.deepToString(this.getAliases()) + ", permissionMessage=" + this.getPermissionMessage() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected void setPermissionMessage(final String permissionMessage) {
        this.permissionMessage = permissionMessage;
    }
}
