// Generated by delombok at Tue Dec 16 19:35:27 UTC 2025
package net.md_5.bungee.api.event;

import lombok.NonNull;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;

/**
 * Called when the player is disconnected from a server, for example during
 * server switching.
 *
 * If the player is kicked from a server, {@link ServerKickEvent} will be called
 * instead.
 */
public class ServerDisconnectEvent extends Event {
    /**
     * Player disconnecting from a server.
     */
    @NonNull
    private final ProxiedPlayer player;
    /**
     * Server the player is disconnecting from.
     */
    @NonNull
    private final ServerInfo target;

    /**
     * Player disconnecting from a server.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProxiedPlayer getPlayer() {
        return this.player;
    }

    /**
     * Server the player is disconnecting from.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerInfo getTarget() {
        return this.target;
    }

    /**
     * Creates a new {@code ServerDisconnectEvent} instance.
     *
     * @param player Player disconnecting from a server.
     * @param target Server the player is disconnecting from.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerDisconnectEvent(@NonNull final ProxiedPlayer player, @NonNull final ServerInfo target) {
        if (player == null) {
            throw new java.lang.NullPointerException("player is marked non-null but is null");
        }
        if (target == null) {
            throw new java.lang.NullPointerException("target is marked non-null but is null");
        }
        this.player = player;
        this.target = target;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ServerDisconnectEvent(player=" + this.getPlayer() + ", target=" + this.getTarget() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServerDisconnectEvent)) return false;
        final ServerDisconnectEvent other = (ServerDisconnectEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$player = this.getPlayer();
        final java.lang.Object other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) return false;
        final java.lang.Object this$target = this.getTarget();
        final java.lang.Object other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ServerDisconnectEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $player = this.getPlayer();
        result = result * PRIME + ($player == null ? 43 : $player.hashCode());
        final java.lang.Object $target = this.getTarget();
        result = result * PRIME + ($target == null ? 43 : $target.hashCode());
        return result;
    }
}
