// Generated by delombok at Tue Dec 16 19:35:27 UTC 2025
package net.md_5.bungee.api;

import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;

/**
 * Represents a server link which may be sent to the client.
 */
public final class ServerLink {
    /**
     * The links type.
     *
     * Note: This value is nullable, if null, label is non-null.
     */
    private final LinkType type;
    /**
     * The label for the link.
     *
     * Note: This value is nullable, if null, type is non-null.
     */
    private final BaseComponent label;
    /**
     * The URL that is displayed.
     */
    @NonNull
    private final String url;

    /**
     * Creates a link with a specified type and URL.
     *
     * @param type the type of the link
     * @param url the URL to be displayed
     */
    public ServerLink(@NonNull LinkType type, @NonNull String url) {
        if (type == null) {
            throw new java.lang.NullPointerException("type is marked non-null but is null");
        }
        if (url == null) {
            throw new java.lang.NullPointerException("url is marked non-null but is null");
        }
        this.type = type;
        this.label = null;
        this.url = url;
    }

    /**
     * Creates a link with a label and URL.
     *
     * @param label the label to be displayed
     * @param url the URL to be displayed
     */
    public ServerLink(@NonNull BaseComponent label, @NonNull String url) {
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        if (url == null) {
            throw new java.lang.NullPointerException("url is marked non-null but is null");
        }
        this.type = null;
        this.label = label;
        this.url = url;
    }


    public enum LinkType {
        REPORT_BUG, COMMUNITY_GUIDELINES, SUPPORT, STATUS, FEEDBACK, COMMUNITY, WEBSITE, FORUMS, NEWS, ANNOUNCEMENTS;
    }

    /**
     * The links type.
     *
     * Note: This value is nullable, if null, label is non-null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LinkType getType() {
        return this.type;
    }

    /**
     * The label for the link.
     *
     * Note: This value is nullable, if null, type is non-null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent getLabel() {
        return this.label;
    }

    /**
     * The URL that is displayed.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
        return this.url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServerLink)) return false;
        final ServerLink other = (ServerLink) o;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$label = this.getLabel();
        final java.lang.Object other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
        final java.lang.Object this$url = this.getUrl();
        final java.lang.Object other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $label = this.getLabel();
        result = result * PRIME + ($label == null ? 43 : $label.hashCode());
        final java.lang.Object $url = this.getUrl();
        result = result * PRIME + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ServerLink(type=" + this.getType() + ", label=" + this.getLabel() + ", url=" + this.getUrl() + ")";
    }

    /**
     * Creates a new {@code ServerLink} instance.
     *
     * @param type The links type.
     *
     * Note: This value is nullable, if null, label is non-null.
     * @param label The label for the link.
     *
     * Note: This value is nullable, if null, type is non-null.
     * @param url The URL that is displayed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private ServerLink(final LinkType type, final BaseComponent label, @NonNull final String url) {
        if (url == null) {
            throw new java.lang.NullPointerException("url is marked non-null but is null");
        }
        this.type = type;
        this.label = label;
        this.url = url;
    }
}
