/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.exception.NBTFormatException;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class CompoundTag
implements TypedTag {
    private static final int MAP_SIZE_IN_BYTES = 48;
    private static final int MAP_ENTRY_SIZE_IN_BYTES = 32;
    private Map<String, TypedTag> value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        byte type;
        limiter.push();
        limiter.countBytes(48L);
        LinkedHashMap<String, TypedTag> map = new LinkedHashMap<String, TypedTag>();
        while ((type = input.readByte()) != 0) {
            TypedTag tag;
            String name = CompoundTag.readString(input, limiter);
            if (map.put(name, tag = Tag.readById(type, input, limiter)) != null) continue;
            limiter.countBytes(36L);
        }
        limiter.pop();
        this.value = map;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(this.value, (Object)"compound tag map cannot be null");
        for (Map.Entry<String, TypedTag> entry : this.value.entrySet()) {
            String name = entry.getKey();
            TypedTag tag = entry.getValue();
            output.writeByte(tag.getId());
            if (tag.getId() == 0) {
                throw new NBTFormatException("invalid end tag in compound tag");
            }
            CompoundTag.writeString(name, output);
            tag.write(output);
        }
        output.writeByte(0);
    }

    @Override
    public byte getId() {
        return 10;
    }

    public static String readString(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(28L);
        String string = input.readUTF();
        limiter.countBytes(string.length(), 2L);
        return string;
    }

    public static void writeString(String string, DataOutput output) throws IOException {
        output.writeUTF(string);
    }

    public TypedTag get(String key) {
        return this.value.get(key);
    }

    public void put(String key, TypedTag tag) {
        this.value.put(key, tag);
    }

    public int size() {
        return this.value.size();
    }

    @Generated
    public Map<String, TypedTag> getValue() {
        return this.value;
    }

    @Generated
    public void setValue(Map<String, TypedTag> value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompoundTag)) {
            return false;
        }
        CompoundTag other = (CompoundTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, TypedTag> this$value = this.getValue();
        Map<String, TypedTag> other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CompoundTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, TypedTag> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CompoundTag(value=" + this.getValue() + ")";
    }

    @Generated
    public CompoundTag() {
    }

    @Generated
    public CompoundTag(Map<String, TypedTag> value) {
        this.value = value;
    }
}

