// Generated by delombok at Wed Jan 14 00:42:22 UTC 2026
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class LongArrayTag implements TypedTag {
    private long[] value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(OBJECT_HEADER + ARRAY_HEADER + Integer.BYTES);
        int length = input.readInt();
        limiter.countBytes(length, Long.BYTES);
        long[] data = new long[length];
        for (int i = 0; i < length; i++) {
            data[i] = input.readLong();
        }
        value = data;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(value, "long array value cannot be null");
        output.writeInt(value.length);
        for (long i : value) {
            output.writeLong(i);
        }
    }

    @Override
    public byte getId() {
        return Tag.LONG_ARRAY;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long[] getValue() {
        return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final long[] value) {
        this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LongArrayTag)) return false;
        final LongArrayTag other = (LongArrayTag) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!java.util.Arrays.equals(this.getValue(), other.getValue())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LongArrayTag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + java.util.Arrays.hashCode(this.getValue());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LongArrayTag(value=" + java.util.Arrays.toString(this.getValue()) + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LongArrayTag() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LongArrayTag(final long[] value) {
        this.value = value;
    }
}
