// Generated by delombok at Wed Jan 14 00:42:22 UTC 2026
package net.md_5.bungee.nbt.type;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class FloatTag implements TypedTag {
    private float value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(OBJECT_HEADER + Float.BYTES);
        value = input.readFloat();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeFloat(value);
    }

    @Override
    public byte getId() {
        return Tag.FLOAT;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public float getValue() {
        return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final float value) {
        this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FloatTag)) return false;
        final FloatTag other = (FloatTag) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (java.lang.Float.compare(this.getValue(), other.getValue()) != 0) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FloatTag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + java.lang.Float.floatToIntBits(this.getValue());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "FloatTag(value=" + this.getValue() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FloatTag() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FloatTag(final float value) {
        this.value = value;
    }
}
