// Generated by delombok at Tue Dec 16 19:35:03 UTC 2025
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class StringTag implements TypedTag {
    private String value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(OBJECT_HEADER + STRING_SIZE);
        String string = input.readUTF();
        limiter.countBytes(string.length(), Character.BYTES);
        value = string;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(value, "string value cannot be null");
        output.writeUTF(value);
    }

    @Override
    public byte getId() {
        return Tag.STRING;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
        return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final String value) {
        this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof StringTag)) return false;
        final StringTag other = (StringTag) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$value = this.getValue();
        final java.lang.Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof StringTag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "StringTag(value=" + this.getValue() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public StringTag() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public StringTag(final String value) {
        this.value = value;
    }
}
