// Generated by delombok at Tue Dec 16 19:35:03 UTC 2025
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class ByteArrayTag implements TypedTag {
    private byte[] value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(OBJECT_HEADER + ARRAY_HEADER + Integer.BYTES);
        int length = input.readInt();
        limiter.countBytes(length, Byte.BYTES);
        input.readFully(value = new byte[length]);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(value, "byte array value cannot be null");
        output.writeInt(value.length);
        output.write(value);
    }

    @Override
    public byte getId() {
        return Tag.BYTE_ARRAY;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte[] getValue() {
        return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final byte[] value) {
        this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ByteArrayTag)) return false;
        final ByteArrayTag other = (ByteArrayTag) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!java.util.Arrays.equals(this.getValue(), other.getValue())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ByteArrayTag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + java.util.Arrays.hashCode(this.getValue());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ByteArrayTag(value=" + java.util.Arrays.toString(this.getValue()) + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ByteArrayTag() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ByteArrayTag(final byte[] value) {
        this.value = value;
    }
}
