// Generated by delombok at Tue Dec 16 19:34:11 UTC 2025
package net.md_5.bungee.chat;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public final class TranslationRegistry {
    public static final TranslationRegistry INSTANCE = new TranslationRegistry();
    //
    private final List<TranslationProvider> providers = new LinkedList<>();

    static {
        try {
            INSTANCE.addProvider(new JsonProvider("/assets/minecraft/lang/en_us.json"));
        } catch (Exception ex) {
        }
        try {
            INSTANCE.addProvider(new JsonProvider("/mojang-translations/en_us.json"));
        } catch (Exception ex) {
        }
        try {
            INSTANCE.addProvider(new ResourceBundleProvider("mojang-translations/en_US"));
        } catch (Exception ex) {
        }
    }

    private void addProvider(TranslationProvider provider) {
        providers.add(provider);
    }

    public String translate(String s) {
        for (TranslationProvider provider : providers) {
            String translation = provider.translate(s);
            if (translation != null) {
                return translation;
            }
        }
        return s;
    }


    private interface TranslationProvider {
        String translate(String s);
    }


    private static class ResourceBundleProvider implements TranslationProvider {
        private final ResourceBundle bundle;

        public ResourceBundleProvider(String bundlePath) {
            this.bundle = ResourceBundle.getBundle(bundlePath);
        }

        @Override
        public String translate(String s) {
            return (bundle.containsKey(s)) ? bundle.getString(s) : null;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ResourceBundle getBundle() {
            return this.bundle;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof TranslationRegistry.ResourceBundleProvider)) return false;
            final TranslationRegistry.ResourceBundleProvider other = (TranslationRegistry.ResourceBundleProvider) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$bundle = this.getBundle();
            final java.lang.Object other$bundle = other.getBundle();
            if (this$bundle == null ? other$bundle != null : !this$bundle.equals(other$bundle)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof TranslationRegistry.ResourceBundleProvider;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $bundle = this.getBundle();
            result = result * PRIME + ($bundle == null ? 43 : $bundle.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TranslationRegistry.ResourceBundleProvider(bundle=" + this.getBundle() + ")";
        }
    }


    private static class JsonProvider implements TranslationProvider {
        private final Map<String, String> translations = new HashMap<>();

        public JsonProvider(String resourcePath) throws IOException {
            try (InputStreamReader rd = new InputStreamReader(JsonProvider.class.getResourceAsStream(resourcePath), StandardCharsets.UTF_8)) {
                JsonObject obj = new Gson().fromJson(rd, JsonObject.class);
                for (Map.Entry<String, JsonElement> entries : obj.entrySet()) {
                    translations.put(entries.getKey(), entries.getValue().getAsString());
                }
            }
        }

        @Override
        public String translate(String s) {
            return translations.get(s);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, String> getTranslations() {
            return this.translations;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof TranslationRegistry.JsonProvider)) return false;
            final TranslationRegistry.JsonProvider other = (TranslationRegistry.JsonProvider) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$translations = this.getTranslations();
            final java.lang.Object other$translations = other.getTranslations();
            if (this$translations == null ? other$translations != null : !this$translations.equals(other$translations)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof TranslationRegistry.JsonProvider;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $translations = this.getTranslations();
            result = result * PRIME + ($translations == null ? 43 : $translations.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TranslationRegistry.JsonProvider()";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<TranslationProvider> getProviders() {
        return this.providers;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TranslationRegistry)) return false;
        final TranslationRegistry other = (TranslationRegistry) o;
        final java.lang.Object this$providers = this.getProviders();
        final java.lang.Object other$providers = other.getProviders();
        if (this$providers == null ? other$providers != null : !this$providers.equals(other$providers)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $providers = this.getProviders();
        result = result * PRIME + ($providers == null ? 43 : $providers.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TranslationRegistry(providers=" + this.getProviders() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private TranslationRegistry() {
    }
}
