/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.query;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import lombok.Generated;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class QueryHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private final ProxyServer bungee;
    private final ListenerInfo listener;
    private final Random random = new Random();
    private final Cache<InetAddress, QuerySession> sessions = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    private void writeShort(ByteBuf buf, int s) {
        buf.writeShortLE(s);
    }

    private void writeNumber(ByteBuf buf, int i) {
        this.writeString(buf, Integer.toString(i));
    }

    private void writeString(ByteBuf buf, String s) {
        for (char c : s.toCharArray()) {
            buf.writeByte(c);
        }
        buf.writeByte(0);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
        try {
            this.handleMessage(ctx, msg);
        }
        catch (Throwable t) {
            this.bungee.getLogger().log(Level.WARNING, "Error whilst handling query packet from " + msg.sender(), t);
        }
    }

    private void handleMessage(ChannelHandlerContext ctx, DatagramPacket msg) {
        int challengeToken;
        ByteBuf in = (ByteBuf)msg.content();
        if (in.readUnsignedByte() != 254 || in.readUnsignedByte() != 253) {
            this.bungee.getLogger().log(Level.WARNING, "Query - Incorrect magic!: {0}", msg.sender());
            return;
        }
        ByteBuf out = ctx.alloc().buffer();
        DatagramPacket response = new DatagramPacket(out, (InetSocketAddress)msg.sender());
        byte type = in.readByte();
        int sessionId = in.readInt();
        if (type == 9) {
            out.writeByte(9);
            out.writeInt(sessionId);
            challengeToken = this.random.nextInt();
            this.sessions.put(((InetSocketAddress)msg.sender()).getAddress(), new QuerySession(challengeToken, System.currentTimeMillis()));
            this.writeNumber(out, challengeToken);
        }
        if (type == 0) {
            challengeToken = in.readInt();
            QuerySession session = this.sessions.getIfPresent(((InetSocketAddress)msg.sender()).getAddress());
            if (session == null || session.getToken() != challengeToken) {
                throw new IllegalStateException("No session!");
            }
            out.writeByte(0);
            out.writeInt(sessionId);
            if (in.readableBytes() == 0) {
                this.writeString(out, this.listener.getMotd());
                this.writeString(out, "SMP");
                this.writeString(out, "BungeeCord_Proxy");
                this.writeNumber(out, this.bungee.getOnlineCount());
                this.writeNumber(out, this.listener.getMaxPlayers());
                this.writeShort(out, this.listener.getHost().getPort());
                this.writeString(out, this.listener.getHost().getHostString());
            } else if (in.readableBytes() == 4) {
                out.writeBytes(new byte[]{115, 112, 108, 105, 116, 110, 117, 109, 0, -128, 0});
                LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                data.put("hostname", this.listener.getMotd());
                data.put("gametype", "SMP");
                data.put("game_id", "MINECRAFT");
                data.put("version", this.bungee.getGameVersion());
                data.put("plugins", "");
                data.put("map", "BungeeCord_Proxy");
                data.put("numplayers", Integer.toString(this.bungee.getOnlineCount()));
                data.put("maxplayers", Integer.toString(this.listener.getMaxPlayers()));
                data.put("hostport", Integer.toString(this.listener.getHost().getPort()));
                data.put("hostip", this.listener.getHost().getHostString());
                for (Map.Entry entry : data.entrySet()) {
                    this.writeString(out, (String)entry.getKey());
                    this.writeString(out, (String)entry.getValue());
                }
                out.writeByte(0);
                this.writeString(out, "\u0001player_\u0000");
                for (ProxiedPlayer p : this.bungee.getPlayers()) {
                    this.writeString(out, p.getName());
                }
                out.writeByte(0);
            } else {
                throw new IllegalStateException("Invalid data request packet");
            }
        }
        ctx.writeAndFlush(response);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.bungee.getLogger().log(Level.WARNING, "Error whilst handling query packet from " + ctx.channel().remoteAddress(), cause);
    }

    @Generated
    public QueryHandler(ProxyServer bungee, ListenerInfo listener) {
        this.bungee = bungee;
        this.listener = listener;
    }

    private static class QuerySession {
        private final int token;
        private final long time;

        @Generated
        public QuerySession(int token, long time) {
            this.token = token;
            this.time = time;
        }

        @Generated
        public int getToken() {
            return this.token;
        }

        @Generated
        public long getTime() {
            return this.time;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QuerySession)) {
                return false;
            }
            QuerySession other = (QuerySession)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getToken() != other.getToken()) {
                return false;
            }
            return this.getTime() == other.getTime();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QuerySession;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getToken();
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            return result;
        }

        @Generated
        public String toString() {
            return "QueryHandler.QuerySession(token=" + this.getToken() + ", time=" + this.getTime() + ")";
        }
    }
}

