/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.tab;

import java.beans.ConstructorProperties;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.protocol.packet.PlayerListItem;

public abstract class TabList {
    protected final ProxiedPlayer player;

    public abstract void onUpdate(PlayerListItem var1);

    public abstract void onPingChange(int var1);

    public abstract void onServerChange();

    public abstract void onConnect();

    public abstract void onDisconnect();

    public static PlayerListItem rewrite(PlayerListItem playerListItem) {
        for (PlayerListItem.Item item : playerListItem.getItems()) {
            UserConnection player;
            if (item.getUuid() == null || (player = BungeeCord.getInstance().getPlayerByOfflineUUID(item.getUuid())) == null) continue;
            item.setUuid(player.getUniqueId());
            LoginResult loginResult = player.getPendingConnection().getLoginProfile();
            String[][] props = new String[loginResult.getProperties().length][];
            for (int i = 0; i < props.length; ++i) {
                props[i] = new String[]{loginResult.getProperties()[i].getName(), loginResult.getProperties()[i].getValue(), loginResult.getProperties()[i].getSignature()};
            }
            item.setProperties(props);
            if (playerListItem.getAction() == PlayerListItem.Action.ADD_PLAYER || playerListItem.getAction() == PlayerListItem.Action.UPDATE_GAMEMODE) {
                player.setGamemode(item.getGamemode());
            }
            player.setPing(player.getPing());
        }
        return playerListItem;
    }

    @ConstructorProperties(value={"player"})
    public TabList(ProxiedPlayer player) {
        this.player = player;
    }
}

