/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class PlayerListItem
extends DefinedPacket {
    private String username;
    private boolean online;
    private int ping;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.username = PlayerListItem.readString(buf);
        this.online = buf.readBoolean();
        this.ping = protocolVersion >= 14 ? PlayerListItem.readVarInt(buf) : (int)buf.readShort();
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        PlayerListItem.writeString(this.username, buf);
        buf.writeBoolean(this.online);
        if (protocolVersion >= 14) {
            PlayerListItem.writeVarInt(this.ping, buf);
        } else {
            buf.writeShort(this.ping);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isOnline() {
        return this.online;
    }

    public int getPing() {
        return this.ping;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    @Override
    public String toString() {
        return "PlayerListItem(username=" + this.getUsername() + ", online=" + this.isOnline() + ", ping=" + this.getPing() + ")";
    }

    public PlayerListItem() {
    }

    @ConstructorProperties(value={"username", "online", "ping"})
    public PlayerListItem(String username, boolean online, int ping) {
        this.username = username;
        this.online = online;
        this.ping = ping;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerListItem)) {
            return false;
        }
        PlayerListItem other = (PlayerListItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (this.isOnline() != other.isOnline()) {
            return false;
        }
        return this.getPing() == other.getPing();
    }

    public boolean canEqual(Object other) {
        return other instanceof PlayerListItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 0 : $username.hashCode());
        result = result * 59 + (this.isOnline() ? 79 : 97);
        result = result * 59 + this.getPing();
        return result;
    }
}

