/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.security.AccessControlException;
import java.security.Permission;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;

public class BungeeSecurityManager
extends SecurityManager {
    private static final boolean ENFORCE = false;

    private void checkRestricted(String text) {
        ClassLoader loader;
        Class<?>[] context = this.getClassContext();
        for (int i = 2; i < context.length && (loader = context[i].getClassLoader()) != ClassLoader.getSystemClassLoader() && (loader != null || context[i].getName().startsWith("java.lang")); ++i) {
            if (loader == null) continue;
            AccessControlException ex = new AccessControlException("Plugin violation: " + text);
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Plugin performed restricted action, please inform them to use proper API methods: " + text, ex);
            break;
        }
    }

    @Override
    public void checkExit(int status) {
        this.checkRestricted("Exit: Cannot close VM");
    }

    @Override
    public ThreadGroup getThreadGroup() {
        this.checkRestricted("Thread Creation: Use scheduler");
        return super.getThreadGroup();
    }

    @Override
    public void checkPermission(Permission perm) {
        switch (perm.getName()) {
            case "setSecurityManager": {
                throw new AccessControlException("Restricted Action", perm);
            }
        }
    }
}

