/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Pattern;

public final class NativeLibraryLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NativeLibraryLoader.class);
    private static final Pattern REPLACE = Pattern.compile("\\W+");
    private static final File WORKDIR;

    public static void load(String name, ClassLoader loader) {
        String libname = System.mapLibraryName(name);
        String path = "META-INF/native/" + NativeLibraryLoader.osIdentifier() + PlatformDependent.bitMode() + '/' + libname;
        URL url = loader.getResource(path);
        if (url == null) {
            System.loadLibrary(name);
        } else {
            int index = libname.lastIndexOf(46);
            String prefix = libname.substring(0, index);
            String suffix = libname.substring(index, libname.length());
            InputStream in = null;
            OutputStream out = null;
            File tmpFile = null;
            boolean loaded = false;
            try {
                int length;
                tmpFile = File.createTempFile(prefix, suffix, WORKDIR);
                in = url.openStream();
                out = new FileOutputStream(tmpFile);
                byte[] buffer = new byte[8192];
                while ((length = in.read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
                out.flush();
                out.close();
                out = null;
                System.load(tmpFile.getPath());
                loaded = true;
            }
            catch (Exception e) {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("could not load a native library: " + name).initCause(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignore) {}
                }
                if (tmpFile != null) {
                    if (loaded) {
                        tmpFile.deleteOnExit();
                    } else if (!tmpFile.delete()) {
                        tmpFile.deleteOnExit();
                    }
                }
            }
        }
    }

    private static String osIdentifier() {
        String name = SystemPropertyUtil.get("os.name", "unknown").toLowerCase(Locale.US).trim();
        if (name.startsWith("win")) {
            return "windows";
        }
        if (name.startsWith("mac os x")) {
            return "osx";
        }
        if (name.startsWith("linux")) {
            return "linux";
        }
        return REPLACE.matcher(name).replaceAll("_");
    }

    private NativeLibraryLoader() {
    }

    static {
        String workdir = SystemPropertyUtil.get("io.netty.native.workdir");
        if (workdir != null) {
            File f = new File(workdir);
            if (!f.exists()) {
                f.mkdirs();
            }
            try {
                f = f.getAbsoluteFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WORKDIR = f;
            logger.debug("-Dio.netty.netty.workdir: {}", (Object)WORKDIR);
        } else {
            WORKDIR = PlatformDependent.tmpdir();
            logger.debug("-Dio.netty.netty.workdir: {} (io.netty.tmpdir)", (Object)WORKDIR);
        }
    }
}

