/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;

public class Handshake
extends DefinedPacket {
    private int protocolVersion;
    private String host;
    private int port;
    private int requestedProtocol;

    @Override
    public void read(ByteBuf buf) {
        this.protocolVersion = Handshake.readVarInt(buf);
        this.host = Handshake.readString(buf);
        this.port = buf.readUnsignedShort();
        this.requestedProtocol = Handshake.readVarInt(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        Handshake.writeVarInt(this.protocolVersion, buf);
        Handshake.writeString(this.host, buf);
        buf.writeShort(this.port);
        Handshake.writeVarInt(this.requestedProtocol, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getRequestedProtocol() {
        return this.requestedProtocol;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRequestedProtocol(int requestedProtocol) {
        this.requestedProtocol = requestedProtocol;
    }

    @Override
    public String toString() {
        return "Handshake(protocolVersion=" + this.getProtocolVersion() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", requestedProtocol=" + this.getRequestedProtocol() + ")";
    }

    public Handshake() {
    }

    @ConstructorProperties(value={"protocolVersion", "host", "port", "requestedProtocol"})
    public Handshake(int protocolVersion, String host, int port, int requestedProtocol) {
        this.protocolVersion = protocolVersion;
        this.host = host;
        this.port = port;
        this.requestedProtocol = requestedProtocol;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Handshake)) {
            return false;
        }
        Handshake other = (Handshake)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProtocolVersion() != other.getProtocolVersion()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        return this.getRequestedProtocol() == other.getRequestedProtocol();
    }

    public boolean canEqual(Object other) {
        return other instanceof Handshake;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.getProtocolVersion();
        String $host = this.getHost();
        result = result * 31 + ($host == null ? 0 : $host.hashCode());
        result = result * 31 + this.getPort();
        result = result * 31 + this.getRequestedProtocol();
        return result;
    }
}

