/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;

public class ClientSettings
extends DefinedPacket {
    private String locale;
    private byte viewDistance;
    private byte chatFlags;
    private boolean unknown;
    private byte difficulty;
    private boolean showCape;

    @Override
    public void read(ByteBuf buf) {
        this.locale = ClientSettings.readString(buf);
        this.viewDistance = buf.readByte();
        this.chatFlags = buf.readByte();
        this.unknown = buf.readBoolean();
        this.difficulty = buf.readByte();
        this.showCape = buf.readBoolean();
    }

    @Override
    public void write(ByteBuf buf) {
        ClientSettings.writeString(this.locale, buf);
        buf.writeByte(this.viewDistance);
        buf.writeByte(this.chatFlags);
        buf.writeBoolean(this.unknown);
        buf.writeByte(this.difficulty);
        buf.writeBoolean(this.showCape);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getLocale() {
        return this.locale;
    }

    public byte getViewDistance() {
        return this.viewDistance;
    }

    public byte getChatFlags() {
        return this.chatFlags;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public byte getDifficulty() {
        return this.difficulty;
    }

    public boolean isShowCape() {
        return this.showCape;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setViewDistance(byte viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setChatFlags(byte chatFlags) {
        this.chatFlags = chatFlags;
    }

    public void setUnknown(boolean unknown) {
        this.unknown = unknown;
    }

    public void setDifficulty(byte difficulty) {
        this.difficulty = difficulty;
    }

    public void setShowCape(boolean showCape) {
        this.showCape = showCape;
    }

    @Override
    public String toString() {
        return "ClientSettings(locale=" + this.getLocale() + ", viewDistance=" + this.getViewDistance() + ", chatFlags=" + this.getChatFlags() + ", unknown=" + this.isUnknown() + ", difficulty=" + this.getDifficulty() + ", showCape=" + this.isShowCape() + ")";
    }

    public ClientSettings() {
    }

    @ConstructorProperties(value={"locale", "viewDistance", "chatFlags", "unknown", "difficulty", "showCape"})
    public ClientSettings(String locale, byte viewDistance, byte chatFlags, boolean unknown, byte difficulty, boolean showCape) {
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatFlags = chatFlags;
        this.unknown = unknown;
        this.difficulty = difficulty;
        this.showCape = showCape;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientSettings)) {
            return false;
        }
        ClientSettings other = (ClientSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.getChatFlags() != other.getChatFlags()) {
            return false;
        }
        if (this.isUnknown() != other.isUnknown()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        return this.isShowCape() == other.isShowCape();
    }

    public boolean canEqual(Object other) {
        return other instanceof ClientSettings;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $locale = this.getLocale();
        result = result * 31 + ($locale == null ? 0 : $locale.hashCode());
        result = result * 31 + this.getViewDistance();
        result = result * 31 + this.getChatFlags();
        result = result * 31 + (this.isUnknown() ? 1231 : 1237);
        result = result * 31 + this.getDifficulty();
        result = result * 31 + (this.isShowCape() ? 1231 : 1237);
        return result;
    }
}

